/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.selection;

import com.rapidminer.operator.features.Individual;
import com.rapidminer.operator.features.Population;
import com.rapidminer.operator.features.PopulationOperator;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Random;

public class SelectionCrossover
implements PopulationOperator {
    public static final String[] CROSSOVER_TYPES = new String[]{"one_point", "uniform", "shuffle"};
    public static final int ONE_POINT = 0;
    public static final int UNIFORM = 1;
    public static final int SHUFFLE = 2;
    private int type;
    private double prob;
    private Random random;
    private int minNumber;
    private int maxNumber;
    private int exactNumber;

    public SelectionCrossover(int type, double prob, Random random, int minNumber, int maxNumber, int exactNumber) {
        this.prob = prob;
        this.type = type;
        this.random = random;
        this.minNumber = minNumber;
        this.maxNumber = maxNumber;
        this.exactNumber = exactNumber;
    }

    @Override
    public boolean performOperation(int generation) {
        return true;
    }

    public int getType() {
        return this.type;
    }

    public void crossover(double[] weights1, double[] weights2) {
        switch (this.type) {
            case 0: {
                int n;
                for (int index = n = 1 + this.random.nextInt(weights1.length - 1); index < weights1.length; ++index) {
                    double dummy = weights1[index];
                    weights1[index] = weights2[index];
                    weights2[index] = dummy;
                }
                break;
            }
            case 1: {
                boolean[] swap = new boolean[weights1.length];
                for (int i = 0; i < swap.length; ++i) {
                    swap[i] = this.random.nextBoolean();
                }
                this.swapAttributes(weights1, weights2, swap);
                break;
            }
            case 2: {
                boolean[] swap = new boolean[weights1.length];
                ArrayList<Integer> indices = new ArrayList<Integer>();
                for (int i = 0; i < swap.length; ++i) {
                    indices.add(i);
                }
                if (indices.size() > 0) {
                    int toSwap = this.random.nextInt(indices.size() - 1) + 1;
                    for (int i = 0; i < toSwap; ++i) {
                        swap[((Integer)indices.remove((int)this.random.nextInt((int)indices.size()))).intValue()] = true;
                    }
                }
                this.swapAttributes(weights1, weights2, swap);
                break;
            }
        }
    }

    private void swapAttributes(double[] weights1, double[] weights2, boolean[] swap) {
        for (int index = 0; index < weights1.length; ++index) {
            if (!swap[index]) continue;
            double dummy = weights1[index];
            weights1[index] = weights2[index];
            weights2[index] = dummy;
        }
    }

    @Override
    public void operate(Population population) {
        if (population.getNumberOfIndividuals() < 2) {
            return;
        }
        LinkedList<double[]> matingPool = new LinkedList<double[]>();
        for (int i = 0; i < population.getNumberOfIndividuals(); ++i) {
            matingPool.add(population.get(i).getWeightsClone());
        }
        LinkedList<Individual> l = new LinkedList<Individual>();
        while (matingPool.size() > 1) {
            Individual newIndividual2;
            double[] p1 = (double[])matingPool.remove(this.random.nextInt(matingPool.size()));
            double[] p2 = (double[])matingPool.remove(this.random.nextInt(matingPool.size()));
            if (!(this.random.nextDouble() < this.prob)) continue;
            this.crossover(p1, p2);
            Individual newIndividual1 = new Individual(p1);
            int numberOfFeatures = newIndividual1.getNumberOfUsedAttributes();
            if (numberOfFeatures > 0) {
                if (this.exactNumber > 0) {
                    if (numberOfFeatures == this.exactNumber) {
                        l.add(newIndividual1);
                    }
                } else if ((this.maxNumber < 1 || numberOfFeatures <= this.maxNumber) && numberOfFeatures >= this.minNumber) {
                    l.add(newIndividual1);
                }
            }
            if ((numberOfFeatures = (newIndividual2 = new Individual(p2)).getNumberOfUsedAttributes()) <= 0) continue;
            if (this.exactNumber > 0) {
                if (numberOfFeatures != this.exactNumber) continue;
                l.add(newIndividual2);
                continue;
            }
            if (this.maxNumber >= 1 && numberOfFeatures > this.maxNumber || numberOfFeatures < this.minNumber) continue;
            l.add(newIndividual2);
        }
        population.addAllIndividuals(l);
    }
}

