/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.selection;

import com.rapidminer.example.AttributeWeights;
import com.rapidminer.operator.features.Individual;
import com.rapidminer.operator.features.Population;
import com.rapidminer.operator.features.PopulationOperator;
import com.rapidminer.operator.features.selection.AbstractGeneticAlgorithm;
import com.rapidminer.operator.io.AttributeWeightsWriter;
import com.rapidminer.tools.OperatorService;
import java.io.File;

public class SaveIntermediateWeights
implements PopulationOperator {
    private int whichGeneration;
    private AbstractGeneticAlgorithm operator;
    private String[] attributeNames;

    public SaveIntermediateWeights(AbstractGeneticAlgorithm operator, int whichGeneration, String[] attributeNames) {
        this.operator = operator;
        this.whichGeneration = whichGeneration;
        this.attributeNames = attributeNames;
    }

    @Override
    public void operate(Population pop) throws Exception {
        File outputFile;
        Individual bestIndividual = pop.getBestIndividualEver();
        if (bestIndividual != null && (outputFile = this.operator.getParameterAsFile("intermediate_weights_file", true)) != null) {
            AttributeWeightsWriter writer = OperatorService.createOperator(AttributeWeightsWriter.class);
            writer.setParameter("attribute_weights_file", outputFile.getAbsolutePath());
            double[] weightValues = bestIndividual.getWeights();
            if (weightValues.length == this.attributeNames.length) {
                AttributeWeights weights = new AttributeWeights();
                for (int i = 0; i < weightValues.length; ++i) {
                    weights.setWeight(this.attributeNames[i], weightValues[i]);
                }
                writer.write(weights);
            }
        }
    }

    @Override
    public boolean performOperation(int generation) {
        return generation % this.whichGeneration == 0;
    }
}

