/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.selection;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.features.selection.AbstractFeatureSelection;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import java.util.Iterator;
import java.util.List;

public class RemoveUselessFeatures
extends AbstractFeatureSelection {
    public static final String PARAMETER_NUMERICAL_MIN_DEVIATION = "numerical_min_deviation";
    public static final String PARAMETER_NOMINAL_SINGLE_VALUE_UPPER = "nominal_useless_above";
    public static final String PARAMETER_NOMINAL_SINGLE_VALUE_LOWER = "nominal_useless_below";
    private static final String PARAMETER_REMOVE_ID_LIKE = "nominal_remove_id_like";

    public RemoveUselessFeatures(OperatorDescription description) {
        super(description);
    }

    @Override
    protected MetaData modifyMetaData(ExampleSetMetaData metaData) throws UndefinedParameterError {
        metaData.attributesAreSubset();
        return metaData;
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        exampleSet.recalculateAllAttributeStatistics();
        double numericalMinDeviation = this.getParameterAsDouble(PARAMETER_NUMERICAL_MIN_DEVIATION);
        double nominalSingleValueUpper = this.getParameterAsDouble(PARAMETER_NOMINAL_SINGLE_VALUE_UPPER);
        double nominalSingleValueLower = this.getParameterAsDouble(PARAMETER_NOMINAL_SINGLE_VALUE_LOWER);
        if (this.getParameterAsBoolean(PARAMETER_REMOVE_ID_LIKE)) {
            nominalSingleValueLower = 1.0 / (double)exampleSet.size();
        }
        Iterator<Attribute> i = exampleSet.getAttributes().iterator();
        while (i.hasNext()) {
            Attribute attribute = i.next();
            if (attribute.isNominal()) {
                List<String> values = attribute.getMapping().getValues();
                double[] valueCounts = new double[values.size()];
                Iterator v = values.iterator();
                int n = 0;
                while (v.hasNext()) {
                    String value = (String)v.next();
                    valueCounts[n] = exampleSet.getStatistics(attribute, "count", value);
                    ++n;
                }
                if (exampleSet.getStatistics(attribute, "unknown") / (double)exampleSet.size() >= nominalSingleValueUpper) {
                    i.remove();
                    continue;
                }
                double maximumValueCount = Double.NEGATIVE_INFINITY;
                for (n = 0; n < valueCounts.length; ++n) {
                    double percent = valueCounts[n] / (double)exampleSet.size();
                    maximumValueCount = Math.max(maximumValueCount, percent);
                    if (!(percent >= nominalSingleValueUpper)) continue;
                    i.remove();
                    break;
                }
                if (maximumValueCount <= nominalSingleValueLower) {
                    i.remove();
                    continue;
                }
            } else if (attribute.isNumerical()) {
                if (exampleSet.getStatistics(attribute, "unknown") / (double)exampleSet.size() >= nominalSingleValueUpper) {
                    i.remove();
                    continue;
                }
                if (Math.sqrt(exampleSet.getStatistics(attribute, "variance")) <= numericalMinDeviation) {
                    i.remove();
                }
            } else {
                this.log("Attribute '" + attribute.getName() + "' is not numerical and not nominal, do nothing...");
            }
            this.checkForStop();
        }
        if (exampleSet.getAttributes().size() <= 0) {
            this.logWarning("Example set does not not have any attribute after removing the useless attributes!");
        }
        return exampleSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeDouble type = new ParameterTypeDouble(PARAMETER_NUMERICAL_MIN_DEVIATION, "Removes all numerical attributes with standard deviation less or equal to this threshold.", 0.0, Double.POSITIVE_INFINITY, 0.0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_NOMINAL_SINGLE_VALUE_UPPER, "Removes all nominal attributes which most frequent value is contained in more than this fraction of all examples.", 0.0, 1.0, 1.0);
        type.setExpert(false);
        types.add(type);
        types.add(type);
        types.add(new ParameterTypeBoolean(PARAMETER_REMOVE_ID_LIKE, "If checked, nominal attributes which values appear only once in the complete exampleset are removed.", false, false));
        type = new ParameterTypeDouble(PARAMETER_NOMINAL_SINGLE_VALUE_LOWER, "Removes all nominal attributes which most frequent value is contained in less than this fraction of all examples.", 0.0, 1.0, 0.0);
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_REMOVE_ID_LIKE, false, false));
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

