/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.selection;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ValueDouble;
import com.rapidminer.operator.features.selection.AbstractFeatureSelection;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.tools.Tools;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class RemoveCorrelatedFeatures
extends AbstractFeatureSelection {
    public static final String PARAMETER_CORRELATION = "correlation";
    public static final String PARAMETER_FILTER_RELATION = "filter_relation";
    public static final String PARAMETER_ATTRIBUTE_ORDER = "attribute_order";
    public static final String PARAMETER_USE_ABSOLUTE_CORRELATION = "use_absolute_correlation";
    private static final String[] ORDER = new String[]{"original", "random", "reverse"};
    private static final int ORDER_ORIGINAL = 0;
    private static final int ORDER_RANDOM = 1;
    private static final int ORDER_REVERSE = 2;
    private static final String[] FILTER_RELATIONS = new String[]{"greater", "greater equals", "equals", "less equals", "less"};
    private static final int GREATER = 0;
    private static final int GREATER_EQUALS = 1;
    private static final int EQUALS = 2;
    private static final int LESS_EQUALS = 3;
    private static final int LESS = 4;
    private int removedFeatures = 0;

    public RemoveCorrelatedFeatures(OperatorDescription description) {
        super(description);
        this.addValue(new ValueDouble("features_removed", "Number of removed features"){

            @Override
            public double getDoubleValue() {
                return RemoveCorrelatedFeatures.this.removedFeatures;
            }
        });
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        exampleSet.recalculateAllAttributeStatistics();
        double[] means = new double[exampleSet.getAttributes().size()];
        double[] deviations = new double[exampleSet.getAttributes().size()];
        boolean[] removeFeature = new boolean[exampleSet.getAttributes().size()];
        int[] attributeIndex = new int[exampleSet.getAttributes().size()];
        int index = 0;
        for (Attribute attribute : exampleSet.getAttributes()) {
            means[index] = exampleSet.getStatistics(attribute, "average");
            deviations[index] = Math.sqrt(exampleSet.getStatistics(attribute, "variance"));
            removeFeature[index] = false;
            attributeIndex[index] = index;
            ++index;
        }
        double[][] samples = new double[exampleSet.size()][exampleSet.getAttributes().size()];
        int counter = 0;
        for (Example example : exampleSet) {
            int d = 0;
            for (Attribute attribute : example.getAttributes()) {
                samples[counter][d++] = example.getValue(attribute);
            }
            ++counter;
        }
        int order = this.getParameterAsInt(PARAMETER_ATTRIBUTE_ORDER);
        if (order == 0) {
            for (int i = 0; i < exampleSet.getAttributes().size(); ++i) {
                attributeIndex[i] = i;
            }
        } else if (order == 1) {
            Vector<Integer> vector = new Vector<Integer>();
            for (int i = 0; i < exampleSet.getAttributes().size(); ++i) {
                vector.add(i);
            }
            for (int i = 0; i < exampleSet.getAttributes().size(); ++i) {
                int vindex = (int)Math.floor(Math.random() * (double)vector.size());
                attributeIndex[i] = (Integer)vector.remove(vindex);
            }
        } else if (order == 2) {
            for (int i = 0; i < exampleSet.getAttributes().size(); ++i) {
                attributeIndex[i] = exampleSet.getAttributes().size() - 1 - i;
            }
        }
        boolean absolute = this.getParameterAsBoolean(PARAMETER_USE_ABSOLUTE_CORRELATION);
        int relation = this.getParameterAsInt(PARAMETER_FILTER_RELATION);
        double threshold = this.getParameterAsDouble(PARAMETER_CORRELATION);
        if (absolute && threshold < 0.0) {
            threshold = Math.abs(threshold);
            this.logWarning("Correlation value is lower zero. Setting to absolute: " + threshold);
        }
        Attribute[] allAttributes = exampleSet.getAttributes().createRegularAttributeArray();
        for (int i = 0; i < exampleSet.getAttributes().size() - 1; ++i) {
            if (removeFeature[attributeIndex[i]]) continue;
            for (int j = i + 1; j < exampleSet.getAttributes().size(); ++j) {
                if (removeFeature[attributeIndex[j]]) continue;
                double correlation = this.getCorrelation(samples, means, deviations, attributeIndex[i], attributeIndex[j]);
                if (absolute) {
                    correlation = Math.abs(correlation);
                }
                if (!this.fulfillRelation(correlation, threshold, relation)) continue;
                removeFeature[attributeIndex[j]] = true;
                String first = allAttributes[attributeIndex[i]].getName();
                String second = allAttributes[attributeIndex[j]].getName();
                this.log("Removed Attribute : " + second + " --> correlation(" + first + "," + second + ")=" + correlation);
            }
        }
        this.removedFeatures = 0;
        index = 0;
        Iterator<Attribute> iterator = exampleSet.getAttributes().iterator();
        while (iterator.hasNext()) {
            iterator.next();
            if (removeFeature[index]) {
                iterator.remove();
                ++this.removedFeatures;
            }
            ++index;
        }
        this.log("Removed " + this.removedFeatures + "features." + Tools.getLineSeparator() + "ExampleSet has now " + exampleSet.getAttributes().size() + " features.");
        return exampleSet;
    }

    private boolean fulfillRelation(double correlation, double threshold, int relation) {
        switch (relation) {
            case 0: {
                return correlation > threshold;
            }
            case 1: {
                return correlation >= threshold;
            }
            case 2: {
                return correlation == threshold;
            }
            case 3: {
                return correlation <= threshold;
            }
            case 4: {
                return correlation < threshold;
            }
        }
        return false;
    }

    private double getCorrelation(double[][] samples, double[] means, double[] deviations, int att1, int att2) {
        double covariance = 0.0;
        for (int j = 0; j < samples.length; ++j) {
            covariance += (samples[j][att1] - means[att1]) * (samples[j][att2] - means[att2]);
        }
        double correlation = 0.0;
        correlation = deviations[att1] * deviations[att2];
        correlation = correlation == 0.0 ? covariance : (covariance /= (double)(samples.length - 1)) / correlation;
        return correlation;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeDouble(PARAMETER_CORRELATION, "Use this correlation for the filter relation.", -1.0, 1.0, 0.95);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeCategory(PARAMETER_FILTER_RELATION, "Removes one of two features if their correlation fulfill this relation.", FILTER_RELATIONS, 0);
        types.add(type);
        type = new ParameterTypeCategory(PARAMETER_ATTRIBUTE_ORDER, "The algorithm takes this attribute order to calculate correlation and filter.", ORDER, 0);
        types.add(type);
        type = new ParameterTypeBoolean(PARAMETER_USE_ABSOLUTE_CORRELATION, "Indicates if the absolute value of the correlations should be used for comparison.", true);
        types.add(type);
        return types;
    }
}

