/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.selection;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.features.Individual;
import com.rapidminer.operator.features.Population;
import com.rapidminer.operator.features.PopulationOperator;
import com.rapidminer.operator.features.selection.AbstractGeneticAlgorithm;
import com.rapidminer.operator.features.selection.SelectionCrossover;
import com.rapidminer.operator.features.selection.SelectionMutation;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.metadata.CompatibilityLevel;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.SimplePrecondition;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import java.util.LinkedList;
import java.util.List;

public class GeneticAlgorithm
extends AbstractGeneticAlgorithm {
    public static final String PARAMETER_P_INITIALIZE = "p_initialize";
    public static final String PARAMETER_P_MUTATION = "p_mutation";
    public static final String PARAMETER_P_CROSSOVER = "p_crossover";
    public static final String PARAMETER_CROSSOVER_TYPE = "crossover_type";
    public static final String PARAMETER_MAX_NUMBER_OF_ATTRIBUTES = "max_number_of_attributes";
    public static final String PARAMETER_MIN_NUMBER_OF_ATTRIBUTES = "min_number_of_attributes";
    public static final String PARAMETER_EXACT_NUMBER_OF_ATTRIBUTES = "exact_number_of_attributes";
    public static final String PARAMETER_INITIALIZE_WITH_INPUT_WEIGHTS = "initialize_with_input_weights";
    public static final String PARAMETER_USE_EXACT_NUMBER = "use_exact_number_of_attributes";
    public static final String PARAMETER_RESTRICT_NUMBER = "restrict_maximum";
    private InputPort attributeWeightsInput = (InputPort)this.getInputPorts().createPort("attribute weights in");

    public GeneticAlgorithm(OperatorDescription description) {
        super(description);
        this.attributeWeightsInput.addPrecondition(new SimplePrecondition(this.attributeWeightsInput, new MetaData(AttributeWeights.class), false){

            @Override
            public boolean isCompatible(MetaData input, CompatibilityLevel level) {
                if (GeneticAlgorithm.this.isParameterSet(GeneticAlgorithm.PARAMETER_INITIALIZE_WITH_INPUT_WEIGHTS) && input.getObjectClass().equals(AttributeWeights.class)) {
                    return GeneticAlgorithm.this.getParameterAsBoolean(GeneticAlgorithm.PARAMETER_INITIALIZE_WITH_INPUT_WEIGHTS);
                }
                return false;
            }

            @Override
            protected boolean isMandatory() {
                if (GeneticAlgorithm.this.isParameterSet(GeneticAlgorithm.PARAMETER_INITIALIZE_WITH_INPUT_WEIGHTS)) {
                    return GeneticAlgorithm.this.getParameterAsBoolean(GeneticAlgorithm.PARAMETER_INITIALIZE_WITH_INPUT_WEIGHTS);
                }
                return false;
            }
        });
    }

    @Override
    protected ExampleSetMetaData modifyInnerOutputExampleSet(ExampleSetMetaData metaData) {
        metaData.attributesAreSubset();
        return metaData;
    }

    @Override
    protected ExampleSetMetaData modifyOutputExampleSet(ExampleSetMetaData metaData) {
        metaData.attributesAreSubset();
        return metaData;
    }

    @Override
    public Population createInitialPopulation(ExampleSet es) throws OperatorException {
        double[] weights;
        int minNumber = 1;
        int maxNumber = 1;
        int exactNumber = 0;
        boolean useExactNumber = false;
        boolean restrictMaxNumber = false;
        int numberOfAttributes = es.getAttributes().size();
        if (this.getParameterAsBoolean(PARAMETER_USE_EXACT_NUMBER)) {
            useExactNumber = true;
            exactNumber = this.getParameterAsInt(PARAMETER_EXACT_NUMBER_OF_ATTRIBUTES);
            this.logNote("Using exact number of features for feature selection (" + exactNumber + "), ignoring possibly defined range for the number of features and / or input attribute weights.");
        } else {
            minNumber = this.getParameterAsInt(PARAMETER_MIN_NUMBER_OF_ATTRIBUTES);
            if (this.getParameterAsBoolean(PARAMETER_RESTRICT_NUMBER)) {
                maxNumber = this.getParameterAsInt(PARAMETER_MAX_NUMBER_OF_ATTRIBUTES);
                restrictMaxNumber = true;
            } else {
                maxNumber = numberOfAttributes;
            }
            if (minNumber > maxNumber) {
                throw new UserError((Operator)this, 210, PARAMETER_MAX_NUMBER_OF_ATTRIBUTES, PARAMETER_MIN_NUMBER_OF_ATTRIBUTES);
            }
        }
        Population initP = new Population();
        double[] initialWeights = null;
        if (this.attributeWeightsInput.isConnected()) {
            AttributeWeights inputWeights = null;
            inputWeights = (AttributeWeights)this.attributeWeightsInput.getData();
            initialWeights = new double[numberOfAttributes];
            int index = 0;
            for (Attribute attribute : es.getAttributes()) {
                double weight = inputWeights.getWeight(attribute.getName());
                if (Double.isNaN(weight)) {
                    weight = this.getRandom().nextDouble();
                }
                if (weight < 0.0) {
                    weight = 0.0;
                }
                if (weight > 1.0) {
                    weight = 1.0;
                }
                if (weight > 0.0 && weight < 1.0) {
                    weight = weight < 1.0 - this.getParameterAsDouble(PARAMETER_P_INITIALIZE) ? 1.0 : 0.0;
                }
                initialWeights[index++] = weight;
            }
            if (!useExactNumber) {
                Individual individual = new Individual(initialWeights);
                int numberOfFeatures = individual.getNumberOfUsedAttributes();
                if (!(restrictMaxNumber && numberOfFeatures > maxNumber || numberOfFeatures < minNumber)) {
                    initP.add(individual);
                } else {
                    this.logWarning("Input attribute weights found but number of selected features do not match specified minimum and maximum number, ignoring input weights.");
                    initialWeights = null;
                }
            }
        }
        if (useExactNumber) {
            while (initP.getNumberOfIndividuals() < this.getParameterAsInt("population_size")) {
                weights = new double[numberOfAttributes];
                double prob = 1.0 / (double)weights.length * (double)exactNumber;
                for (int i = 0; i < weights.length; ++i) {
                    weights[i] = this.getRandom().nextDouble() < prob ? 1.0 : 0.0;
                }
                Individual individual = new Individual(weights);
                int numberOfFeatures = individual.getNumberOfUsedAttributes();
                if (exactNumber != numberOfFeatures) continue;
                initP.add(individual);
            }
        } else {
            while (initP.getNumberOfIndividuals() < this.getParameterAsInt("population_size")) {
                weights = new double[numberOfAttributes];
                if (initialWeights != null && this.getRandom().nextBoolean()) {
                    for (int i = 0; i < weights.length; ++i) {
                        if (this.getRandom().nextDouble() < 1.0 / (double)initialWeights.length) {
                            if (initialWeights[i] > 0.0) {
                                weights[i] = 0.0;
                                continue;
                            }
                            weights[i] = 1.0;
                            continue;
                        }
                        weights[i] = initialWeights[i];
                    }
                } else {
                    double p = this.getParameterAsDouble(PARAMETER_P_INITIALIZE);
                    for (int i = 0; i < weights.length; ++i) {
                        if (!(this.getRandom().nextDouble() < 1.0 - p)) continue;
                        weights[i] = 1.0;
                    }
                }
                Individual individual = new Individual(weights);
                int numberOfSelectedAttributes = individual.getNumberOfUsedAttributes();
                while (numberOfSelectedAttributes < minNumber && numberOfAttributes >= minNumber) {
                    int random = this.getRandom().nextInt(numberOfAttributes);
                    if (weights[random] != 0.0) continue;
                    weights[random] = 1.0;
                    ++numberOfSelectedAttributes;
                }
                if (restrictMaxNumber && maxNumber > minNumber) {
                    while (numberOfSelectedAttributes > maxNumber) {
                        double deSelectProb = (double)(numberOfSelectedAttributes - maxNumber) / ((double)numberOfSelectedAttributes - 1.0);
                        for (int i = 0; i < numberOfAttributes; ++i) {
                            if (!(weights[i] > 0.0) || !(this.getRandom().nextDouble() < deSelectProb)) continue;
                            weights[i] = 0.0;
                            --numberOfSelectedAttributes;
                        }
                    }
                }
                if (restrictMaxNumber && numberOfSelectedAttributes > maxNumber || numberOfSelectedAttributes < minNumber) continue;
                initP.add(individual);
            }
        }
        return initP;
    }

    @Override
    protected PopulationOperator getMutationPopulationOperator(ExampleSet eSet) throws UndefinedParameterError {
        double pMutation = this.getParameterAsDouble(PARAMETER_P_MUTATION);
        int minNumber = 1;
        int maxNumber = 1;
        int exactNumber = 0;
        boolean useExactNumber = false;
        boolean restrictMaxNumber = false;
        if (this.getParameterAsBoolean(PARAMETER_USE_EXACT_NUMBER)) {
            useExactNumber = true;
            exactNumber = this.getParameterAsInt(PARAMETER_EXACT_NUMBER_OF_ATTRIBUTES);
            this.logNote("Using exact number of features for feature selection (" + exactNumber + "), ignoring possibly defined range for the number of features and / or input attribute weights.");
        } else {
            minNumber = this.getParameterAsInt(PARAMETER_MIN_NUMBER_OF_ATTRIBUTES);
            if (this.getParameterAsBoolean(PARAMETER_RESTRICT_NUMBER)) {
                maxNumber = this.getParameterAsInt(PARAMETER_MAX_NUMBER_OF_ATTRIBUTES);
                restrictMaxNumber = true;
            } else {
                maxNumber = eSet.getAttributes().size();
            }
        }
        return new SelectionMutation(pMutation, this.getRandom(), minNumber, restrictMaxNumber ? maxNumber : -1, useExactNumber ? exactNumber : -1);
    }

    @Override
    protected PopulationOperator getCrossoverPopulationOperator(ExampleSet eSet) throws UndefinedParameterError {
        double pCrossover = this.getParameterAsDouble(PARAMETER_P_CROSSOVER);
        int crossoverType = this.getParameterAsInt(PARAMETER_CROSSOVER_TYPE);
        int minNumber = 1;
        int maxNumber = 1;
        int exactNumber = 0;
        boolean useExactNumber = false;
        boolean restrictMaxNumber = false;
        if (this.getParameterAsBoolean(PARAMETER_USE_EXACT_NUMBER)) {
            useExactNumber = true;
            exactNumber = this.getParameterAsInt(PARAMETER_EXACT_NUMBER_OF_ATTRIBUTES);
            this.logNote("Using exact number of features for feature selection (" + exactNumber + "), ignoring possibly defined range for the number of features and / or input attribute weights.");
        } else {
            minNumber = this.getParameterAsInt(PARAMETER_MIN_NUMBER_OF_ATTRIBUTES);
            if (this.getParameterAsBoolean(PARAMETER_RESTRICT_NUMBER)) {
                maxNumber = this.getParameterAsInt(PARAMETER_MAX_NUMBER_OF_ATTRIBUTES);
                restrictMaxNumber = true;
            } else {
                maxNumber = eSet.getAttributes().size();
            }
        }
        return new SelectionCrossover(crossoverType, pCrossover, this.getRandom(), minNumber, restrictMaxNumber ? maxNumber : -1, useExactNumber ? exactNumber : -1);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        ParameterTypeSingle type = new ParameterTypeBoolean(PARAMETER_USE_EXACT_NUMBER, "Determines if only combinations containing this numbers of attributes should be tested.", false);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeBoolean(PARAMETER_RESTRICT_NUMBER, "If checked the maximal number of attributes might be restricted. Otherwise all combinations of all number of attributes are generated and tested.", false);
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_USE_EXACT_NUMBER, false, false));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_MIN_NUMBER_OF_ATTRIBUTES, "Determines the minimum number of features used for the combinations.", 1, Integer.MAX_VALUE, 1);
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_USE_EXACT_NUMBER, true, false));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_MAX_NUMBER_OF_ATTRIBUTES, "Determines the maximum number of features used for the combinations.", 1, Integer.MAX_VALUE, 1);
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_RESTRICT_NUMBER, true, true));
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_USE_EXACT_NUMBER, true, false));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_EXACT_NUMBER_OF_ATTRIBUTES, "Determines the exact number of features used for the combinations.", 1, Integer.MAX_VALUE, 1);
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_USE_EXACT_NUMBER, true, true));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeBoolean(PARAMETER_INITIALIZE_WITH_INPUT_WEIGHTS, "Indicates if this operator should look for attribute weights in the given input and use the input weights of all known attributes as starting point for the optimization.", false);
        type.setDeprecated();
        types.add(type);
        types.addAll(super.getParameterTypes());
        type = new ParameterTypeDouble(PARAMETER_P_INITIALIZE, "Initial probability for an attribute to be switched on.", 0.0, 1.0, 0.5);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_P_MUTATION, "Probability for an attribute to be changed (-1: 1 / numberOfAtt).", -1.0, 1.0, -1.0);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_P_CROSSOVER, "Probability for an individual to be selected for crossover.", 0.0, 1.0, 0.5);
        types.add(type);
        type = new ParameterTypeCategory(PARAMETER_CROSSOVER_TYPE, "Type of the crossover.", SelectionCrossover.CROSSOVER_TYPES, 1);
        type.setExpert(true);
        types.add(type);
        return types;
    }
}

