/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.selection;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.ExampleSetPassThroughRule;
import com.rapidminer.operator.ports.metadata.GenerateNewMDRule;
import com.rapidminer.operator.ports.metadata.PassThroughRule;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.operator.ports.metadata.SubprocessTransformRule;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeInt;
import java.util.Iterator;
import java.util.List;

@Deprecated
public class ForwardSelectionOperator
extends OperatorChain {
    public static final String PARAMETER_NUMBER_OF_STEPS = "number_of_steps";
    private final InputPort exampleSetInput = this.getInputPorts().createPort("training set", ExampleSet.class);
    private final OutputPort innerExampleSource = (OutputPort)this.getSubprocess(0).getInnerSources().createPort("training set");
    private final InputPort innerPerformanceSink = this.getSubprocess(0).getInnerSinks().createPort("performance vector", PerformanceVector.class);
    private final OutputPort performanceVectorOutput = (OutputPort)this.getOutputPorts().createPort("performance vector");
    private final OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set");
    private final OutputPort attributeWeightsOutput = (OutputPort)this.getOutputPorts().createPort("attribute weights");

    public ForwardSelectionOperator(OperatorDescription description) {
        super(description, "Learning Process");
        this.getTransformer().addRule(new PassThroughRule(this.exampleSetInput, this.innerExampleSource, true));
        this.getTransformer().addRule(new SubprocessTransformRule(this.getSubprocess(0)));
        this.getTransformer().addRule(new PassThroughRule(this.innerPerformanceSink, this.performanceVectorOutput, true));
        this.getTransformer().addRule(new ExampleSetPassThroughRule(this.exampleSetInput, this.exampleSetOutput, SetRelation.SUBSET));
        this.getTransformer().addRule(new GenerateNewMDRule(this.attributeWeightsOutput, AttributeWeights.class));
    }

    @Override
    public void doWork() throws OperatorException {
        ExampleSet exampleSetOriginal = (ExampleSet)this.exampleSetInput.getData();
        ExampleSet exampleSet = (ExampleSet)exampleSetOriginal.clone();
        int numberOfSteps = this.getParameterAsInt(PARAMETER_NUMBER_OF_STEPS);
        int numberOfAttributes = exampleSet.getAttributes().size();
        Attributes attributes = exampleSet.getAttributes();
        Attribute[] attributeArray = new Attribute[numberOfAttributes];
        int i = 0;
        Iterator<Attribute> iterator = attributes.iterator();
        while (iterator.hasNext()) {
            Attribute attribute;
            attributeArray[i] = attribute = iterator.next();
            ++i;
            iterator.remove();
        }
        boolean[] selected = new boolean[numberOfAttributes];
        PerformanceVector bestPerformance = null;
        for (i = 0; i < numberOfSteps; ++i) {
            int bestIndex = 0;
            boolean gain = false;
            for (int current = 0; current < numberOfAttributes; ++current) {
                if (selected[current]) continue;
                attributes.addRegular(attributeArray[current]);
                this.innerExampleSource.deliver(exampleSet);
                this.getSubprocess(0).execute();
                PerformanceVector performance = (PerformanceVector)this.innerPerformanceSink.getData();
                if (bestPerformance == null || performance.compareTo(bestPerformance) > 0) {
                    bestIndex = current;
                    bestPerformance = performance;
                    gain = true;
                }
                attributes.remove(attributeArray[current]);
            }
            if (!gain) break;
            attributes.addRegular(attributeArray[bestIndex]);
            selected[bestIndex] = true;
        }
        AttributeWeights weights = new AttributeWeights();
        i = 0;
        for (Attribute attribute : attributeArray) {
            if (selected[i]) {
                weights.setWeight(attribute.getName(), 1.0);
            } else {
                weights.setWeight(attribute.getName(), 0.0);
            }
            ++i;
        }
        this.performanceVectorOutput.deliver(bestPerformance);
        this.attributeWeightsOutput.deliver(weights);
        this.exampleSetOutput.deliver(exampleSet);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeInt(PARAMETER_NUMBER_OF_STEPS, "number of forward selection steps", 1, Integer.MAX_VALUE, 10));
        return types;
    }
}

