/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.selection;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ValueDouble;
import com.rapidminer.operator.ValueString;
import com.rapidminer.operator.performance.PerformanceCriterion;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.SubprocessTransformRule;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.parameter.conditions.EqualTypeCondition;
import com.rapidminer.tools.math.AnovaCalculator;
import com.rapidminer.tools.math.SignificanceCalculationException;
import com.rapidminer.tools.math.SignificanceTestResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ForwardAttributeSelectionOperator
extends OperatorChain {
    public static final String PARAMETER_STOPPING_BEHAVIOR = "stopping_behavior";
    public static final String PARAMETER_MAX_ATTRIBUTES = "maximal_number_of_attributes";
    public static final String PARAMETER_MIN_RELATIVE_INCREASE = "minimal_relative_increase";
    public static final String PARAMETER_MIN_ABSOLUT_INCREASE = "minimal_absolute_increase";
    public static final String PARAMETER_USE_RELATIVE_INCREASE = "use_relative_increase";
    public static final String PARAMETER_ALPHA = "alpha";
    public static final String PARAMETER_ALLOWED_CONSECUTIVE_FAILS = "speculative_rounds";
    public static final String[] STOPPING_BEHAVIORS = new String[]{"without increase", "without increase of at least", "without significant increase"};
    public static final int WITHOUT_INCREASE = 0;
    public static final int WITHOUT_INCREASE_OF_AT_LEAST = 1;
    public static final int WITHOUT_INCREASE_SIGNIFICANT = 2;
    private double currentNumberOfFeatures = 0.0;
    private Attributes currentAttributes;
    private InputPort exampleSetInput = this.getInputPorts().createPort("example set", ExampleSet.class);
    private OutputPort innerExampleSetSource = (OutputPort)this.getSubprocess(0).getInnerSources().createPort("example set");
    private InputPort innerPerformanceSink = this.getSubprocess(0).getInnerSinks().createPort("performance", PerformanceVector.class);
    private OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set");
    private OutputPort weightsOutput = (OutputPort)this.getOutputPorts().createPort("attribute weights");
    private OutputPort performanceOutput = (OutputPort)this.getOutputPorts().createPort("performance");

    public ForwardAttributeSelectionOperator(OperatorDescription description) {
        super(description, "Learning Process");
        this.getTransformer().addPassThroughRule(this.exampleSetInput, this.innerExampleSetSource);
        this.getTransformer().addRule(new SubprocessTransformRule(this.getSubprocess(0)));
        this.getTransformer().addPassThroughRule(this.exampleSetInput, this.exampleSetOutput);
        this.getTransformer().addGenerationRule(this.performanceOutput, PerformanceVector.class);
        this.getTransformer().addGenerationRule(this.weightsOutput, AttributeWeights.class);
        this.addValue(new ValueDouble("number of attributes", "The current number of attributes."){

            @Override
            public double getDoubleValue() {
                return ForwardAttributeSelectionOperator.this.currentNumberOfFeatures;
            }
        });
        this.addValue(new ValueString("feature_names", "A comma separated list of all features of this round."){

            @Override
            public String getStringValue() {
                StringBuffer buffer = new StringBuffer();
                for (Attribute attribute : ForwardAttributeSelectionOperator.this.currentAttributes) {
                    if (buffer.length() > 0) {
                        buffer.append(", ");
                    }
                    buffer.append(attribute.getName());
                }
                return buffer.toString();
            }
        });
    }

    @Override
    public void doWork() throws OperatorException {
        ExampleSet exampleSetOriginal = (ExampleSet)this.exampleSetInput.getData();
        ExampleSet exampleSet = (ExampleSet)exampleSetOriginal.clone();
        int numberOfAttributes = exampleSet.getAttributes().size();
        Attributes attributes = exampleSet.getAttributes();
        int maxNumberOfAttributes = Math.min(this.getParameterAsInt(PARAMETER_MAX_ATTRIBUTES), numberOfAttributes);
        int maxNumberOfFails = this.getParameterAsInt(PARAMETER_ALLOWED_CONSECUTIVE_FAILS);
        int behavior = this.getParameterAsInt(PARAMETER_STOPPING_BEHAVIOR);
        boolean useRelativeIncrease = behavior == 1 ? this.getParameterAsBoolean(PARAMETER_USE_RELATIVE_INCREASE) : false;
        double minimalIncrease = 0.0;
        if (useRelativeIncrease) {
            minimalIncrease = useRelativeIncrease ? this.getParameterAsDouble(PARAMETER_MIN_RELATIVE_INCREASE) : this.getParameterAsDouble(PARAMETER_MIN_ABSOLUT_INCREASE);
        }
        double alpha = behavior == 2 ? this.getParameterAsDouble(PARAMETER_ALPHA) : 0.0;
        Attribute[] attributeArray = new Attribute[numberOfAttributes];
        int i = 0;
        Iterator<Attribute> iterator = attributes.iterator();
        while (iterator.hasNext()) {
            Attribute attribute;
            attributeArray[i] = attribute = iterator.next();
            ++i;
            iterator.remove();
        }
        boolean[] selected = new boolean[numberOfAttributes];
        boolean earlyAbort = false;
        ArrayList<Integer> speculativeList = new ArrayList<Integer>(maxNumberOfFails);
        int numberOfFails = maxNumberOfFails;
        PerformanceVector lastPerformance = null;
        PerformanceVector bestPerformanceEver = null;
        for (i = 0; i < maxNumberOfAttributes && !earlyAbort; ++i) {
            this.currentNumberOfFeatures = i + 1;
            int bestIndex = 0;
            PerformanceVector currentBestPerformance = null;
            for (int current = 0; current < numberOfAttributes; ++current) {
                if (selected[current]) continue;
                attributes.addRegular(attributeArray[current]);
                this.currentAttributes = attributes;
                this.innerExampleSetSource.deliver(exampleSet);
                this.getSubprocess(0).execute();
                PerformanceVector performance = (PerformanceVector)this.innerPerformanceSink.getData();
                if (currentBestPerformance == null || performance.compareTo(currentBestPerformance) > 0) {
                    bestIndex = current;
                    currentBestPerformance = performance;
                }
                attributes.remove(attributeArray[current]);
                this.currentAttributes = null;
            }
            double currentFitness = currentBestPerformance.getMainCriterion().getFitness();
            if (i != 0) {
                double lastFitness = lastPerformance.getMainCriterion().getFitness();
                switch (behavior) {
                    case 0: {
                        if (!(lastFitness >= currentFitness)) break;
                        earlyAbort = true;
                        break;
                    }
                    case 1: {
                        if (useRelativeIncrease) {
                            if (currentFitness > lastFitness + lastFitness * minimalIncrease) break;
                            earlyAbort = true;
                            break;
                        }
                        if (currentFitness > lastFitness + minimalIncrease) break;
                        earlyAbort = true;
                        break;
                    }
                    case 2: {
                        SignificanceTestResult result;
                        AnovaCalculator calculator = new AnovaCalculator();
                        calculator.setAlpha(alpha);
                        PerformanceCriterion pc = currentBestPerformance.getMainCriterion();
                        calculator.addGroup(pc.getAverageCount(), pc.getAverage(), pc.getVariance());
                        pc = lastPerformance.getMainCriterion();
                        calculator.addGroup(pc.getAverageCount(), pc.getAverage(), pc.getVariance());
                        try {
                            result = calculator.performSignificanceTest();
                        }
                        catch (SignificanceCalculationException e) {
                            throw new UserError((Operator)this, 920, e.getMessage());
                        }
                        if (!(lastFitness <= currentFitness) && !(result.getProbability() < alpha)) break;
                        earlyAbort = true;
                    }
                }
            }
            if (earlyAbort) {
                if (numberOfFails == 0) break;
                --numberOfFails;
                speculativeList.add(bestIndex);
                earlyAbort = false;
                if (currentBestPerformance.compareTo(lastPerformance) > 0) {
                    lastPerformance = currentBestPerformance;
                }
            } else {
                numberOfFails = maxNumberOfFails;
                speculativeList.clear();
                lastPerformance = currentBestPerformance;
                bestPerformanceEver = currentBestPerformance;
            }
            attributes.addRegular(attributeArray[bestIndex]);
            selected[bestIndex] = true;
        }
        for (Integer removeIndex : speculativeList) {
            selected[removeIndex.intValue()] = false;
            attributes.remove(attributeArray[removeIndex]);
        }
        AttributeWeights weights = new AttributeWeights();
        i = 0;
        for (Attribute attribute : attributeArray) {
            if (selected[i]) {
                weights.setWeight(attribute.getName(), 1.0);
            } else {
                weights.setWeight(attribute.getName(), 0.0);
            }
            ++i;
        }
        this.exampleSetOutput.deliver(exampleSet);
        this.performanceOutput.deliver(bestPerformanceEver);
        this.weightsOutput.deliver(weights);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeInt(PARAMETER_MAX_ATTRIBUTES, "The maximal number of forward selection steps and hence the maximal number of attributes.", 1, Integer.MAX_VALUE, 10);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_ALLOWED_CONSECUTIVE_FAILS, "Defines the number of times, the stopping criterion might be consecutivly ignored before the selection is actually stopped. A number higher than one might help not to stack in the local optima.", 0, Integer.MAX_VALUE, 0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeCategory(PARAMETER_STOPPING_BEHAVIOR, "Defines on what criterias the selection is stopped.", STOPPING_BEHAVIORS, 0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeBoolean(PARAMETER_USE_RELATIVE_INCREASE, "If checked, the relative performance increase will be used as stopping criterion.", true);
        type.setExpert(false);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_STOPPING_BEHAVIOR, STOPPING_BEHAVIORS, false, 1));
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_MIN_ABSOLUT_INCREASE, "If the absolut performance increase to the last step drops below this threshold, the selection will be stopped.", 0.0, Double.POSITIVE_INFINITY, true);
        type.setExpert(false);
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_USE_RELATIVE_INCREASE, true, false));
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_STOPPING_BEHAVIOR, STOPPING_BEHAVIORS, false, 1));
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_MIN_RELATIVE_INCREASE, "If the relative performance increase to the last step drops below this threshold, the selection will be stopped.", 0.0, 1.0, true);
        type.setExpert(false);
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_USE_RELATIVE_INCREASE, true, true));
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_STOPPING_BEHAVIOR, STOPPING_BEHAVIORS, false, 1));
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_ALPHA, "The probability threshold which determines if differences are considered as significant.", 0.0, 1.0, 0.05);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_STOPPING_BEHAVIOR, STOPPING_BEHAVIORS, true, 2));
        types.add(type);
        return types;
    }
}

