/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.selection;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.features.FeatureOperator;
import com.rapidminer.operator.features.Individual;
import com.rapidminer.operator.features.Population;
import com.rapidminer.operator.features.PopulationOperator;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import java.util.LinkedList;
import java.util.List;

public class BruteForceSelection
extends FeatureOperator {
    public static final String PARAMETER_USE_EXACT_NUMBER = "use_exact_number_of_attributes";
    public static final String PARAMETER_RESTRICT_NUMBER = "restrict_maximum";
    public static final String PARAMETER_MIN_NUMBER_OF_ATTRIBUTES = "min_number_of_attributes";
    public static final String PARAMETER_MAX_NUMBER_OF_ATTRIBUTES = "max_number_of_attributes";
    public static final String PARAMETER_EXACT_NUMBER_OF_ATTRIBUTES = "exact_number_of_attributes";

    public BruteForceSelection(OperatorDescription description) {
        super(description);
    }

    @Override
    protected ExampleSetMetaData modifyInnerOutputExampleSet(ExampleSetMetaData metaData) {
        metaData.attributesAreSubset();
        return metaData;
    }

    @Override
    protected ExampleSetMetaData modifyOutputExampleSet(ExampleSetMetaData metaData) {
        metaData.attributesAreSubset();
        return metaData;
    }

    @Override
    public Population createInitialPopulation(ExampleSet es) throws OperatorException {
        int minNumberOfFeatures = this.getParameterAsInt(PARAMETER_MIN_NUMBER_OF_ATTRIBUTES);
        int maxNumberOfFeatures = this.getParameterAsInt(PARAMETER_MAX_NUMBER_OF_ATTRIBUTES);
        int exactNumberOfFeatures = this.getParameterAsInt(PARAMETER_EXACT_NUMBER_OF_ATTRIBUTES);
        if (this.getParameterAsBoolean(PARAMETER_USE_EXACT_NUMBER)) {
            this.logNote("Using exact number of features for feature selection (" + exactNumberOfFeatures + "), ignoring possibly defined range for the number of features.");
        } else if (!this.getParameterAsBoolean(PARAMETER_RESTRICT_NUMBER)) {
            maxNumberOfFeatures = es.getAttributes().size();
        } else if (minNumberOfFeatures > maxNumberOfFeatures) {
            throw new UserError((Operator)this, 210, PARAMETER_MAX_NUMBER_OF_ATTRIBUTES, PARAMETER_MIN_NUMBER_OF_ATTRIBUTES);
        }
        Population pop = new Population();
        double[] weights = new double[es.getAttributes().size()];
        if (this.getParameterAsBoolean(PARAMETER_USE_EXACT_NUMBER)) {
            this.addAllWithExactNumber(pop, weights, 0, exactNumberOfFeatures);
        } else {
            this.addAllInRange(pop, weights, 0, minNumberOfFeatures, maxNumberOfFeatures);
        }
        return pop;
    }

    private void addAllWithExactNumber(Population pop, double[] weights, int startIndex, int exactNumberOfFeatures) {
        Individual individual = new Individual(weights);
        if (individual.getNumberOfUsedAttributes() > exactNumberOfFeatures) {
            return;
        }
        for (int i = startIndex; i < weights.length; ++i) {
            double[] clone = individual.getWeightsClone();
            clone[i] = 1.0;
            Individual newIndividual = new Individual(clone);
            if (newIndividual.getNumberOfUsedAttributes() == exactNumberOfFeatures) {
                pop.add(newIndividual);
                continue;
            }
            this.addAllWithExactNumber(pop, clone, i + 1, exactNumberOfFeatures);
        }
    }

    private void addAllInRange(Population pop, double[] weights, int startIndex, int minNumberOfFeatures, int maxNumberOfFeatures) {
        if (startIndex >= weights.length) {
            return;
        }
        Individual individual = new Individual(weights);
        int numberOfFeatures = individual.getNumberOfUsedAttributes();
        if (maxNumberOfFeatures > 0 && numberOfFeatures > maxNumberOfFeatures) {
            return;
        }
        double[] clone = individual.getWeightsClone();
        clone[startIndex] = 0.0;
        this.addAllInRange(pop, clone, startIndex + 1, minNumberOfFeatures, maxNumberOfFeatures);
        double[] clone2 = individual.getWeightsClone();
        clone2[startIndex] = 1.0;
        Individual newIndividual = new Individual(clone2);
        numberOfFeatures = newIndividual.getNumberOfUsedAttributes();
        if (numberOfFeatures > 0 && (maxNumberOfFeatures < 1 || numberOfFeatures <= maxNumberOfFeatures) && numberOfFeatures >= minNumberOfFeatures) {
            pop.add(newIndividual);
        }
        this.addAllInRange(pop, clone2, startIndex + 1, minNumberOfFeatures, maxNumberOfFeatures);
    }

    @Override
    public List<PopulationOperator> getPreEvaluationPopulationOperators(ExampleSet input) throws OperatorException {
        return new LinkedList<PopulationOperator>();
    }

    @Override
    public List<PopulationOperator> getPostEvaluationPopulationOperators(ExampleSet input) throws OperatorException {
        return new LinkedList<PopulationOperator>();
    }

    @Override
    public boolean solutionGoodEnough(Population pop) {
        return true;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        ParameterTypeSingle type = new ParameterTypeBoolean(PARAMETER_USE_EXACT_NUMBER, "Determines if only combinations containing this numbers of attributes should be tested.", false);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeBoolean(PARAMETER_RESTRICT_NUMBER, "If checked the maximal number of attributes might be restricted. Otherwise all combinations of all number of attributes are generated and tested.", false);
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_USE_EXACT_NUMBER, false, false));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_MIN_NUMBER_OF_ATTRIBUTES, "Determines the minimum number of features used for the combinations.", 1, Integer.MAX_VALUE, 1);
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_USE_EXACT_NUMBER, true, false));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_MAX_NUMBER_OF_ATTRIBUTES, "Determines the maximum number of features used for the combinations.", 1, Integer.MAX_VALUE, 1);
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_RESTRICT_NUMBER, true, true));
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_USE_EXACT_NUMBER, true, false));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_EXACT_NUMBER_OF_ATTRIBUTES, "Determines the exact number of features used for the combinations.", 1, Integer.MAX_VALUE, 1);
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_USE_EXACT_NUMBER, true, true));
        type.setExpert(false);
        types.add(type);
        types.addAll(super.getParameterTypes());
        return types;
    }
}

