/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.selection;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.preprocessing.AbstractDataProcessing;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.conditions.EqualTypeCondition;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class AttributeWeightSelection
extends AbstractDataProcessing {
    public static final String PARAMETER_WEIGHT = "weight";
    public static final String PARAMETER_WEIGHT_RELATION = "weight_relation";
    public static final String PARAMETER_K = "k";
    public static final String PARAMETER_P = "p";
    public static final String PARAMETER_DESELECT_UNKNOWN = "deselect_unknown";
    public static final String PARAMETER_USE_ABSOLUTE_WEIGHTS = "use_absolute_weights";
    private static final String[] WEIGHT_RELATIONS = new String[]{"greater", "greater equals", "equals", "less equals", "less", "top k", "bottom k", "all but top k", "all but bottom k", "top p%", "bottom p%"};
    private static final int GREATER = 0;
    private static final int GREATER_EQUALS = 1;
    private static final int EQUALS = 2;
    private static final int LESS_EQUALS = 3;
    private static final int LESS = 4;
    private static final int TOPK = 5;
    private static final int BOTTOMK = 6;
    private static final int ALLBUTTOPK = 7;
    private static final int ALLBUTBOTTOMK = 8;
    private static final int TOPPPERCENT = 9;
    private static final int BOTTOMPPERCENT = 10;
    private InputPort weightsInput = this.getInputPorts().createPort("weights", AttributeWeights.class);
    private OutputPort weightsOutput = (OutputPort)this.getOutputPorts().createPort("weights");

    public AttributeWeightSelection(OperatorDescription description) {
        super(description);
        this.getTransformer().addPassThroughRule(this.weightsInput, this.weightsOutput);
    }

    @Override
    protected MetaData modifyMetaData(ExampleSetMetaData metaData) {
        metaData.attributesAreSubset();
        return metaData;
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        AttributeWeights weights = (AttributeWeights)this.weightsInput.getData();
        boolean deselectUnknown = this.getParameterAsBoolean(PARAMETER_DESELECT_UNKNOWN);
        double relationWeight = this.getParameterAsDouble(PARAMETER_WEIGHT);
        int relation = this.getParameterAsInt(PARAMETER_WEIGHT_RELATION);
        boolean useAbsoluteWeights = this.getParameterAsBoolean(PARAMETER_USE_ABSOLUTE_WEIGHTS);
        boolean[] weightKnown = new boolean[exampleSet.getAttributes().size()];
        Vector<Attribute> knownAttributes = new Vector<Attribute>();
        int index = 0;
        for (Attribute attribute : exampleSet.getAttributes()) {
            double weight = weights.getWeight(attribute.getName());
            if (!Double.isNaN(weight)) {
                knownAttributes.add(attribute);
                weightKnown[index++] = true;
                continue;
            }
            weightKnown[index++] = false;
        }
        int nrAtts = knownAttributes.size();
        int k = this.getParameterAsInt(PARAMETER_K);
        if (relation == 7) {
            relation = 6;
            k = nrAtts - k;
        }
        if (relation == 8) {
            relation = 5;
            k = nrAtts - k;
        }
        if (relation == 9) {
            relation = 5;
            k = (int)Math.round((double)nrAtts * this.getParameterAsDouble(PARAMETER_P));
        }
        if (relation == 10) {
            relation = 6;
            k = (int)Math.round((double)nrAtts * this.getParameterAsDouble(PARAMETER_P));
        }
        if (k < 1) {
            k = 1;
        }
        if (k > nrAtts) {
            k = nrAtts;
        }
        if (relation == 5 || relation == 6) {
            int direction = 1;
            if (relation == 6) {
                direction = -1;
            }
            int comparatorType = 0;
            if (useAbsoluteWeights) {
                comparatorType = 1;
            }
            String[] attributeNames = new String[knownAttributes.size()];
            index = 0;
            for (Attribute attribute : knownAttributes) {
                attributeNames[index++] = attribute.getName();
            }
            weights.sortByWeight(attributeNames, direction, comparatorType);
            Iterator<Attribute> iterator = exampleSet.getAttributes().iterator();
            index = 0;
            while (iterator.hasNext()) {
                Attribute attribute;
                attribute = iterator.next();
                if (!weightKnown[index]) {
                    if (deselectUnknown) {
                        iterator.remove();
                    }
                } else {
                    boolean remove = true;
                    for (int i = 0; i < k; ++i) {
                        if (!attribute.getName().equals(attributeNames[i])) continue;
                        remove = false;
                        break;
                    }
                    if (remove) {
                        iterator.remove();
                    }
                }
                ++index;
            }
        } else {
            Iterator<Attribute> iterator = exampleSet.getAttributes().iterator();
            while (iterator.hasNext()) {
                Attribute attribute = iterator.next();
                double weight = weights.getWeight(attribute.getName());
                if (useAbsoluteWeights) {
                    weight = Math.abs(weight);
                }
                if (Double.isNaN(weight) && deselectUnknown) {
                    iterator.remove();
                    continue;
                }
                switch (relation) {
                    case 0: {
                        if (!(weight <= relationWeight)) break;
                        iterator.remove();
                        break;
                    }
                    case 1: {
                        if (!(weight < relationWeight)) break;
                        iterator.remove();
                        break;
                    }
                    case 2: {
                        if (weight == relationWeight) break;
                        iterator.remove();
                        break;
                    }
                    case 3: {
                        if (!(weight > relationWeight)) break;
                        iterator.remove();
                        break;
                    }
                    case 4: {
                        if (!(weight >= relationWeight)) break;
                        iterator.remove();
                    }
                }
            }
        }
        this.weightsOutput.deliver(weights);
        return exampleSet;
    }

    @Override
    public boolean shouldAutoConnect(OutputPort port) {
        if (port == this.weightsOutput) {
            return this.getParameterAsBoolean("keep_attribute_weights");
        }
        return super.shouldAutoConnect(port);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeCategory(PARAMETER_WEIGHT_RELATION, "Selects only weights which fulfill this relation.", WEIGHT_RELATIONS, 1);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_WEIGHT, "The selected relation will be evaluated against this value.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 1.0);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_WEIGHT_RELATION, WEIGHT_RELATIONS, true, 0, 1, 4, 3, 2));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_K, "Number k of attributes to be selected. For example 'top k' with k = 5 will return an exampleset containing only the 5 highest weighted attributes.", 1, Integer.MAX_VALUE, 10);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_WEIGHT_RELATION, WEIGHT_RELATIONS, true, 5, 6, 8, 7));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_P, "Percentage of attributes to be selected. For example 'top p%' with p = 15 will return an exampleset containing only attributes which are part of the 15% of the highest weighted attributes.", 0.0, 1.0, 0.5);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_WEIGHT_RELATION, WEIGHT_RELATIONS, true, 9, 10));
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeBoolean(PARAMETER_DESELECT_UNKNOWN, "Indicates if attributes which weight is unknown should be removed from example set.", true));
        types.add(new ParameterTypeBoolean(PARAMETER_USE_ABSOLUTE_WEIGHTS, "Indicates if the absolute values of the weights should be used for comparison.", true));
        return types;
    }

    @Override
    public boolean writesIntoExistingData() {
        return false;
    }
}

