/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.construction;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.generator.FeatureGenerator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.features.construction.AbstractGeneratingGeneticAlgorithm;
import com.rapidminer.operator.features.construction.ExampleSetBasedIndividual;
import com.rapidminer.operator.features.construction.ExampleSetBasedPopulation;
import com.rapidminer.operator.features.construction.ExampleSetBasedPopulationOperator;
import com.rapidminer.operator.features.construction.GeneratingMutation;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import java.util.LinkedList;
import java.util.List;

public class YAGGA
extends AbstractGeneratingGeneticAlgorithm {
    public static final String PARAMETER_P_MUTATION = "p_mutation";
    public static final String PARAMETER_USE_HEURISTIC_MUTATION_PROBABILITY = "use_heuristic_mutation_probability";
    public static final String PARAMETER_MAX_TOTAL_NUMBER_OF_ATTRIBUTES = "max_total_number_of_attributes";
    public static final String PARAMETER_LIMIT_MAX_TOTAL_NUMBER_OF_ATTRIBUTES = "limit_max_total_number_of_attributes";

    public YAGGA(OperatorDescription description) {
        super(description);
    }

    @Override
    protected ExampleSetBasedPopulationOperator getGeneratingPopulationOperator(ExampleSet exampleSet) {
        return null;
    }

    @Override
    protected ExampleSetBasedPopulationOperator getMutationPopulationOperator(ExampleSet eSet) throws OperatorException {
        List<FeatureGenerator> generators = this.getGenerators();
        if (generators.size() == 0) {
            this.getLogger().warning("No FeatureGenerators specified for " + this.getName() + ".");
        } else {
            this.getLogger().fine("YAGGA Generators: " + generators);
        }
        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
        for (Attribute attribute : eSet.getAttributes()) {
            attributes.add(attribute);
        }
        double pMutation = this.getParameterAsBoolean(PARAMETER_USE_HEURISTIC_MUTATION_PROBABILITY) ? -1.0 : this.getParameterAsDouble(PARAMETER_P_MUTATION);
        int maxNumberOfAttributes = this.getParameterAsBoolean(PARAMETER_LIMIT_MAX_TOTAL_NUMBER_OF_ATTRIBUTES) ? this.getParameterAsInt(PARAMETER_MAX_TOTAL_NUMBER_OF_ATTRIBUTES) : -1;
        return new GeneratingMutation(attributes, pMutation, maxNumberOfAttributes, generators, this.getRandom());
    }

    @Override
    public ExampleSetBasedPopulation createInitialPopulation(ExampleSet es) throws UndefinedParameterError {
        ExampleSetBasedPopulation population = super.createInitialPopulation(es);
        ExampleSetBasedPopulation popRemovedDeselected = new ExampleSetBasedPopulation();
        for (int i = 0; i < population.getNumberOfIndividuals(); ++i) {
            popRemovedDeselected.add(new ExampleSetBasedIndividual(population.get(i).getExampleSet().createCleanClone()));
        }
        return popRemovedDeselected;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        ParameterTypeSingle type = new ParameterTypeBoolean(PARAMETER_LIMIT_MAX_TOTAL_NUMBER_OF_ATTRIBUTES, "Indicates if the total number of attributes in all generations should be limited.", false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_MAX_TOTAL_NUMBER_OF_ATTRIBUTES, "Max total number of attributes in all generations.", 1, Integer.MAX_VALUE, 1);
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_LIMIT_MAX_TOTAL_NUMBER_OF_ATTRIBUTES, false, true));
        types.add(type);
        types.addAll(super.getParameterTypes());
        types.add(new ParameterTypeBoolean(PARAMETER_USE_HEURISTIC_MUTATION_PROBABILITY, "If checked the probability for mutations will be chosen as 1/number of attributes.", true));
        type = new ParameterTypeDouble(PARAMETER_P_MUTATION, "Probability for mutation.", 0.0, 1.0, true);
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_USE_HEURISTIC_MUTATION_PROBABILITY, true, false));
        types.add(type);
        return types;
    }
}

