/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.construction;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.set.AttributeWeightedExampleSet;
import com.rapidminer.operator.features.construction.ExampleSetBasedSelectionCrossover;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;

public class UnbalancedCrossover
extends ExampleSetBasedSelectionCrossover {
    private Random random;

    public UnbalancedCrossover(int type, double prob, Random random) {
        super(type, prob, random, 1, Integer.MAX_VALUE, -1);
        this.random = random;
    }

    @Override
    public void crossover(AttributeWeightedExampleSet es1, AttributeWeightedExampleSet es2) {
        LinkedList<AttributeWeightContainer> dummyList1 = new LinkedList<AttributeWeightContainer>();
        LinkedList<AttributeWeightContainer> dummyList2 = new LinkedList<AttributeWeightContainer>();
        int maxSize = Math.max(es1.getAttributes().size(), es2.getAttributes().size());
        if (maxSize < 2) {
            return;
        }
        switch (this.getType()) {
            case 0: {
                double weight;
                Attribute attribute;
                int splitPoint = 1 + this.random.nextInt(maxSize - 2);
                Iterator<Attribute> it = es1.getAttributes().iterator();
                int counter = 0;
                while (it.hasNext()) {
                    attribute = it.next();
                    if (counter > splitPoint) {
                        weight = es1.getWeight(attribute);
                        it.remove();
                        dummyList1.add(new AttributeWeightContainer(attribute, weight));
                    }
                    ++counter;
                }
                it = es2.getAttributes().iterator();
                counter = 0;
                while (it.hasNext()) {
                    attribute = it.next();
                    if (counter > splitPoint) {
                        weight = es2.getWeight(attribute);
                        it.remove();
                        dummyList2.add(new AttributeWeightContainer(attribute, weight));
                    }
                    ++counter;
                }
                break;
            }
            case 1: {
                double weight;
                Attribute attribute;
                Iterator<Attribute> it = es1.getAttributes().iterator();
                while (it.hasNext()) {
                    attribute = it.next();
                    if (!this.random.nextBoolean()) continue;
                    weight = es1.getWeight(attribute);
                    dummyList1.add(new AttributeWeightContainer(attribute, weight));
                    it.remove();
                }
                it = es2.getAttributes().iterator();
                while (it.hasNext()) {
                    attribute = it.next();
                    if (!this.random.nextBoolean()) continue;
                    weight = es2.getWeight(attribute);
                    dummyList2.add(new AttributeWeightContainer(attribute, weight));
                    it.remove();
                }
                break;
            }
            case 2: {
                double prob1 = (double)(this.random.nextInt(es1.getAttributes().size() - 1) + 1) / (double)es1.getAttributes().size();
                Iterator<Attribute> it = es1.getAttributes().iterator();
                while (it.hasNext()) {
                    Attribute attribute = it.next();
                    if (!(this.random.nextDouble() < prob1)) continue;
                    double weight = es1.getWeight(attribute);
                    dummyList1.add(new AttributeWeightContainer(attribute, weight));
                    it.remove();
                }
                double prob2 = (double)(this.random.nextInt(es2.getAttributes().size() - 1) + 1) / (double)es2.getAttributes().size();
                it = es2.getAttributes().iterator();
                while (it.hasNext()) {
                    Attribute attribute = it.next();
                    if (!(this.random.nextDouble() < prob2)) continue;
                    double weight = es2.getWeight(attribute);
                    dummyList2.add(new AttributeWeightContainer(attribute, weight));
                    it.remove();
                }
                break;
            }
        }
        this.mergeAttributes(es1, dummyList2);
        this.mergeAttributes(es2, dummyList1);
    }

    private void mergeAttributes(AttributeWeightedExampleSet exampleSet, List<AttributeWeightContainer> attributeWeights) {
        for (AttributeWeightContainer attributeWeight : attributeWeights) {
            Attribute attribute = attributeWeight.getAttribute();
            if (exampleSet.getAttributes().get(attribute.getName()) == null) {
                exampleSet.getAttributes().addRegular(attribute);
            }
            exampleSet.setWeight(attribute, attributeWeight.getWeight());
        }
    }

    private static class AttributeWeightContainer {
        private Attribute attribute;
        private double weight;

        public AttributeWeightContainer(Attribute attribute, double weight) {
            this.attribute = attribute;
            this.weight = weight;
        }

        public Attribute getAttribute() {
            return this.attribute;
        }

        public double getWeight() {
            return this.weight;
        }

        public String toString() {
            return this.attribute.getName() + "(" + this.weight + ")";
        }
    }
}

