/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.construction;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.set.AttributeWeightedExampleSet;
import com.rapidminer.operator.features.construction.ExampleSetBasedIndividual;
import com.rapidminer.operator.features.construction.ExampleSetBasedIndividualOperator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class RemoveUselessAttributes
extends ExampleSetBasedIndividualOperator {
    @Override
    public List<ExampleSetBasedIndividual> operate(ExampleSetBasedIndividual individual) throws Exception {
        AttributeWeightedExampleSet exampleSet = individual.getExampleSet();
        AttributeWeightedExampleSet clone = (AttributeWeightedExampleSet)exampleSet.clone();
        clone.recalculateAllAttributeStatistics();
        Iterator<Attribute> i = clone.getAttributes().iterator();
        while (i.hasNext()) {
            double max;
            double min;
            Attribute attribute = i.next();
            double weight = clone.getWeight(attribute);
            if (weight == 0.0) {
                i.remove();
                continue;
            }
            if (attribute.isNominal() || (min = clone.getStatistics(attribute, "minimum")) != (max = clone.getStatistics(attribute, "maximum")) || min != 0.0 && max != 1.0) continue;
            i.remove();
        }
        LinkedList<ExampleSetBasedIndividual> l = new LinkedList<ExampleSetBasedIndividual>();
        if (clone.getNumberOfUsedAttributes() > 0) {
            l.add(new ExampleSetBasedIndividual(clone));
        } else {
            exampleSet.getLog().logWarning("No attributes left after removing useless attributes! Using original example set.");
            l.add(new ExampleSetBasedIndividual(exampleSet));
        }
        return l;
    }
}

