/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.construction;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.features.construction.AbstractFeatureConstruction;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MDInteger;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttributes;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.math.VectorMath;
import com.rapidminer.tools.math.container.Range;
import java.util.LinkedList;
import java.util.List;

public class ProductGenerationOperator
extends AbstractFeatureConstruction {
    public static final String PARAMETER_FIRST_ATTRIBUTE_NAME = "first_attribute_name";
    public static final String PARAMETER_SECOND_ATTRIBUTE_NAME = "second_attribute_name";

    public ProductGenerationOperator(OperatorDescription description) {
        super(description);
    }

    @Override
    protected MetaData modifyMetaData(ExampleSetMetaData metaData) throws UndefinedParameterError {
        LinkedList<AttributeMetaData> newAttributes = new LinkedList<AttributeMetaData>();
        String firstAttributeName = this.getParameterAsString(PARAMETER_FIRST_ATTRIBUTE_NAME);
        String secondAttributeName = this.getParameterAsString(PARAMETER_SECOND_ATTRIBUTE_NAME);
        for (AttributeMetaData attribute : metaData.getAllAttributes()) {
            if (!attribute.isNumerical() || !attribute.getName().matches(firstAttributeName)) continue;
            for (AttributeMetaData attribute2 : metaData.getAllAttributes()) {
                if (!attribute2.isNumerical() || !attribute2.getName().matches(secondAttributeName)) continue;
                AttributeMetaData newAMD = new AttributeMetaData("(" + attribute.getName() + ") * (" + attribute2.getName() + ")", 4);
                if (attribute.getValueSetRelation() == SetRelation.EQUAL && attribute2.getValueSetRelation() == SetRelation.EQUAL) {
                    Range range1 = attribute.getValueRange();
                    Range range2 = attribute2.getValueRange();
                    double[] values = new double[]{range1.getLower() * range2.getLower(), range1.getLower() * range2.getUpper(), range1.getUpper() * range2.getLower(), range1.getUpper() * range2.getUpper()};
                    newAMD.setValueRange(new Range(VectorMath.minimalElement(values), VectorMath.maximalElement(values)), SetRelation.SUBSET);
                } else {
                    newAMD.setValueRange(new Range(), SetRelation.UNKNOWN);
                }
                if (attribute2.getNumberOfMissingValues().isKnown() && attribute.getNumberOfMissingValues().isKnown()) {
                    newAMD.setNumberOfMissingValues(new MDInteger((Integer)attribute.getNumberOfMissingValues().getValue() + (Integer)attribute2.getNumberOfMissingValues().getValue()));
                }
                newAttributes.add(newAMD);
            }
        }
        metaData.addAllAttributes(newAttributes);
        return metaData;
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        LinkedList<Attribute> newAttributes = new LinkedList<Attribute>();
        String firstAttributeName = this.getParameterAsString(PARAMETER_FIRST_ATTRIBUTE_NAME);
        String secondAttributeName = this.getParameterAsString(PARAMETER_SECOND_ATTRIBUTE_NAME);
        for (Attribute attribute : exampleSet.getAttributes()) {
            if (!attribute.isNumerical() || !attribute.getName().matches(firstAttributeName)) continue;
            for (Attribute attribute2 : exampleSet.getAttributes()) {
                if (!attribute2.isNumerical() || !attribute2.getName().matches(secondAttributeName)) continue;
                newAttributes.add(this.createAttribute(exampleSet, attribute, attribute2));
            }
        }
        for (Attribute attribute : newAttributes) {
            exampleSet.getAttributes().addRegular(attribute);
        }
        return exampleSet;
    }

    private Attribute createAttribute(ExampleSet exampleSet, Attribute attribute1, Attribute attribute2) {
        Attribute result = AttributeFactory.createAttribute("(" + attribute1.getName() + ") * (" + attribute2.getName() + ")", 4);
        exampleSet.getExampleTable().addAttribute(result);
        for (Example example : exampleSet) {
            double value1 = example.getValue(attribute1);
            double value2 = example.getValue(attribute2);
            double resultValue = value1 * value2;
            example.setValue(result, resultValue);
        }
        return result;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeAttributes(PARAMETER_FIRST_ATTRIBUTE_NAME, "The name(s) of the first attribute to be multiplied.", this.getExampleSetInputPort(), false, 2));
        types.add(new ParameterTypeAttributes(PARAMETER_SECOND_ATTRIBUTE_NAME, "The name(s) of the second attribute to be multiplied.", this.getExampleSetInputPort(), false, 2));
        return types;
    }
}

