/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.construction;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.features.construction.AbstractFeatureConstruction;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.UndefinedParameterError;
import java.util.List;

public class LinearCombinationOperator
extends AbstractFeatureConstruction {
    public static final String PARAMETER_KEEP_ALL = "keep_all";

    public LinearCombinationOperator(OperatorDescription description) {
        super(description);
    }

    @Override
    protected MetaData modifyMetaData(ExampleSetMetaData metaData) throws UndefinedParameterError {
        AttributeMetaData amd = new AttributeMetaData("linear_combination", 4);
        if (!this.getParameterAsBoolean(PARAMETER_KEEP_ALL)) {
            metaData.clearRegular();
        }
        metaData.addAttribute(amd);
        return metaData;
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        Attribute newAttribute = AttributeFactory.createAttribute("linear_combination", 4);
        exampleSet.getExampleTable().addAttribute(newAttribute);
        exampleSet.getAttributes().addRegular(newAttribute);
        for (Example example : exampleSet) {
            double valueSum = 0.0;
            for (Attribute attribute : example.getAttributes()) {
                if (((Object)attribute).equals(newAttribute) || !attribute.isNumerical()) continue;
                valueSum += example.getValue(attribute);
            }
            example.setValue(newAttribute, valueSum);
        }
        if (!this.getParameterAsBoolean(PARAMETER_KEEP_ALL)) {
            exampleSet.getAttributes().clearRegular();
            exampleSet.getAttributes().addRegular(newAttribute);
        }
        return exampleSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeBoolean(PARAMETER_KEEP_ALL, "Indicates if all old attributes should be kept.", false));
        return types;
    }
}

