/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.construction;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.generator.FeatureGenerator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.features.construction.AbstractGeneratingGeneticAlgorithm;
import com.rapidminer.operator.features.construction.AttributeGenerator;
import com.rapidminer.operator.features.construction.ExampleSetBasedPopulationOperator;
import com.rapidminer.operator.features.construction.ExampleSetBasedSelectionMutation;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import java.util.LinkedList;
import java.util.List;

public class GeneratingGeneticAlgorithm
extends AbstractGeneratingGeneticAlgorithm {
    public static final String PARAMETER_MAX_NUMBER_OF_NEW_ATTRIBUTES = "max_number_of_new_attributes";
    public static final String PARAMETER_MAX_TOTAL_NUMBER_OF_ATTRIBUTES = "max_total_number_of_attributes";
    public static final String PARAMETER_LIMIT_MAX_TOTAL_NUMBER_OF_ATTRIBUTES = "limit_max_total_number_of_attributes";
    public static final String PARAMETER_P_GENERATE = "p_generate";
    public static final String PARAMETER_P_MUTATION = "p_mutation";
    public static final String PARAMETER_USE_HEURISTIC_MUTATION_PROBABILITY = "use_heuristic_mutation_probability";

    public GeneratingGeneticAlgorithm(OperatorDescription description) {
        super(description);
    }

    @Override
    protected ExampleSetBasedPopulationOperator getMutationPopulationOperator(ExampleSet eSet) throws UndefinedParameterError {
        double pMutation = this.getParameterAsBoolean(PARAMETER_USE_HEURISTIC_MUTATION_PROBABILITY) ? -1.0 : this.getParameterAsDouble(PARAMETER_P_MUTATION);
        return new ExampleSetBasedSelectionMutation(pMutation, this.getRandom(), 1, this.getParameterAsInt(PARAMETER_MAX_TOTAL_NUMBER_OF_ATTRIBUTES), -1);
    }

    @Override
    protected ExampleSetBasedPopulationOperator getGeneratingPopulationOperator(ExampleSet eSet) throws UndefinedParameterError {
        List<FeatureGenerator> generators = this.getGenerators();
        if (generators.size() == 0) {
            this.logWarning("No FeatureGenerators specified for " + this.getName() + ".");
        }
        int noOfNewAttributes = this.getParameterAsInt(PARAMETER_MAX_NUMBER_OF_NEW_ATTRIBUTES);
        int totalNoOfNewAttributes = this.getParameterAsBoolean(PARAMETER_LIMIT_MAX_TOTAL_NUMBER_OF_ATTRIBUTES) ? -1 : this.getParameterAsInt(PARAMETER_MAX_TOTAL_NUMBER_OF_ATTRIBUTES);
        double pGenerate = this.getParameterAsDouble(PARAMETER_P_GENERATE);
        return new AttributeGenerator(pGenerate, noOfNewAttributes, totalNoOfNewAttributes, generators, this.getRandom());
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        ParameterTypeSingle type = new ParameterTypeInt(PARAMETER_MAX_NUMBER_OF_NEW_ATTRIBUTES, "Max number of attributes to generate for an individual in one generation.", 0, Integer.MAX_VALUE, 1);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeBoolean(PARAMETER_LIMIT_MAX_TOTAL_NUMBER_OF_ATTRIBUTES, "Indicates if the total number of attributes in all generations should be limited.", false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_MAX_TOTAL_NUMBER_OF_ATTRIBUTES, "Max total number of attributes in all generations.", 1, Integer.MAX_VALUE, 1);
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_LIMIT_MAX_TOTAL_NUMBER_OF_ATTRIBUTES, false, true));
        types.add(type);
        types.addAll(super.getParameterTypes());
        type = new ParameterTypeDouble(PARAMETER_P_GENERATE, "Probability for an individual to be selected for generation.", 0.0, 1.0, 0.1);
        types.add(type);
        types.add(new ParameterTypeBoolean(PARAMETER_USE_HEURISTIC_MUTATION_PROBABILITY, "If checked the probability for mutations will be chosen as 1/number of attributes.", true));
        type = new ParameterTypeDouble(PARAMETER_P_MUTATION, "Probability for mutation.", 0.0, 1.0);
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_USE_HEURISTIC_MUTATION_PROBABILITY, false, false));
        types.add(type);
        return types;
    }
}

