/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.construction;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.features.construction.AbstractFeatureConstruction;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MDReal;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.operator.tools.AttributeSubsetSelector;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.math.container.Range;
import java.util.LinkedList;
import java.util.List;

public class GaussFeatureConstructionOperator
extends AbstractFeatureConstruction {
    public static final String PARAMETER_MEAN = "mean";
    public static final String PARAMETER_SIGMA = "sigma";

    public GaussFeatureConstructionOperator(OperatorDescription description) {
        super(description);
    }

    @Override
    protected MetaData modifyMetaData(ExampleSetMetaData metaData) throws UndefinedParameterError {
        AttributeSubsetSelector selector = this.getSubsetSelector();
        double mean = this.getParameterAsDouble(PARAMETER_MEAN);
        double sigma = this.getParameterAsDouble(PARAMETER_SIGMA);
        for (AttributeMetaData amd : selector.getMetaDataSubset(metaData, false).getAllAttributes()) {
            AttributeMetaData newAttribute = amd.clone();
            newAttribute.setName("gauss(" + amd.getName() + ", " + mean + ", " + sigma + ")");
            newAttribute.setMean(new MDReal());
            newAttribute.setValueRange(new Range(0.0, 1.0), SetRelation.SUBSET);
            metaData.addAttribute(newAttribute);
        }
        return metaData;
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        AttributeSubsetSelector selector = this.getSubsetSelector();
        double mean = this.getParameterAsDouble(PARAMETER_MEAN);
        double sigma = this.getParameterAsDouble(PARAMETER_SIGMA);
        LinkedList<Attribute> newAttributes = new LinkedList<Attribute>();
        for (Attribute attribute : selector.getAttributeSubset(exampleSet, false)) {
            newAttributes.add(this.createAttribute(exampleSet, attribute, mean, sigma));
        }
        for (Attribute attribute : newAttributes) {
            exampleSet.getAttributes().addRegular(attribute);
        }
        return exampleSet;
    }

    private Attribute createAttribute(ExampleSet exampleSet, Attribute base, double mean, double sigma) {
        Attribute newAttribute = AttributeFactory.createAttribute("gauss(" + base.getName() + ", " + mean + ", " + sigma + ")", 4);
        exampleSet.getExampleTable().addAttribute(newAttribute);
        for (Example example : exampleSet) {
            double value = example.getValue(base);
            double gaussValue = Math.exp(-1.0 * ((value - mean) * (value - mean)) / (sigma * sigma));
            example.setValue(newAttribute, gaussValue);
        }
        return newAttribute;
    }

    private AttributeSubsetSelector getSubsetSelector() {
        return new AttributeSubsetSelector(this, this.getExampleSetInputPort(), 2);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.addAll(this.getSubsetSelector().getParameterTypes());
        types.add(new ParameterTypeDouble(PARAMETER_MEAN, "The mean value for the gaussian function.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0));
        types.add(new ParameterTypeDouble(PARAMETER_SIGMA, "The sigma value for the gaussian function.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 1.0));
        return types;
    }
}

