/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.construction;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.set.AttributeWeightedExampleSet;
import com.rapidminer.generator.AttributePeak;
import com.rapidminer.generator.SinusFactory;
import com.rapidminer.operator.features.construction.ExampleSetBasedIndividual;
import com.rapidminer.operator.features.construction.ExampleSetBasedIndividualOperator;
import com.rapidminer.tools.RandomGenerator;
import java.util.LinkedList;
import java.util.List;

public class FourierGenerator
extends ExampleSetBasedIndividualOperator {
    private SinusFactory factory = null;
    private int startGenerations = 0;
    private int applyInGeneration = 1;
    private RandomGenerator random;

    public FourierGenerator(int maxPeaks, int adaptionType, int attributesPerPeak, double epsilon, RandomGenerator random) {
        this.factory = new SinusFactory(maxPeaks);
        this.factory.setAdaptionType(adaptionType);
        this.factory.setEpsilon(epsilon);
        this.factory.setAttributePerPeak(attributesPerPeak);
        this.random = random;
    }

    public void setStartGenerations(int startGenerations) {
        this.startGenerations = startGenerations;
    }

    public void setApplyInGeneration(int applyInGeneration) {
        this.applyInGeneration = applyInGeneration;
    }

    @Override
    public boolean performOperation(int generation) {
        return generation <= this.startGenerations || this.applyInGeneration != 0 && generation % this.applyInGeneration == 0;
    }

    @Override
    public List<ExampleSetBasedIndividual> operate(ExampleSetBasedIndividual individual) throws Exception {
        AttributeWeightedExampleSet exampleSet = individual.getExampleSet();
        Attribute label = exampleSet.getAttributes().getLabel();
        LinkedList<AttributePeak> attributes = new LinkedList<AttributePeak>();
        for (Attribute current : exampleSet.getAttributes()) {
            if (!current.isNumerical() || current.getConstruction().indexOf("sin") != -1) continue;
            List<AttributePeak> peaks = this.factory.getAttributePeaks(exampleSet, label, current);
            attributes.addAll(peaks);
        }
        if (attributes.size() > 0) {
            this.factory.generateSinusFunctions(exampleSet, attributes, this.random);
        }
        LinkedList<ExampleSetBasedIndividual> result = new LinkedList<ExampleSetBasedIndividual>();
        result.add(new ExampleSetBasedIndividual(exampleSet));
        return result;
    }
}

