/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.construction;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.features.construction.AbstractFeatureConstruction;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeFile;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.tools.math.function.ExpressionParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;

public class FeatureGenerationOperator
extends AbstractFeatureConstruction {
    public static final String PARAMETER_FILENAME = "filename";
    public static final String PARAMETER_FUNCTIONS = "functions";
    public static final String PARAMETER_KEEP_ALL = "keep_all";

    public FeatureGenerationOperator(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        boolean keepAll = this.getParameterAsBoolean(PARAMETER_KEEP_ALL);
        LinkedList<Attribute> oldAttributes = new LinkedList<Attribute>();
        for (Attribute attribute : exampleSet.getAttributes()) {
            oldAttributes.add(attribute);
        }
        File file = this.getParameterAsFile(PARAMETER_FILENAME);
        if (file != null) {
            FileInputStream in = null;
            try {
                in = new FileInputStream(file);
                ExpressionParser.generateAll(this, exampleSet, in);
            }
            catch (IOException e) {
                throw new UserError((Operator)this, (Throwable)e, 302, file, e.getMessage());
            }
            finally {
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException e) {
                        this.getLogger().warning("Cannot close stream to file " + file);
                    }
                }
            }
        }
        ExpressionParser parser = new ExpressionParser(true);
        for (String[] nameFunctionPair : this.getParameterList(PARAMETER_FUNCTIONS)) {
            Attribute attribute = parser.addAttribute(exampleSet, nameFunctionPair[0], nameFunctionPair[1]);
            if (attribute != null) {
                attribute.setName(nameFunctionPair[0]);
                exampleSet.getAttributes().addRegular(attribute);
            } else {
                this.getLogger().warning("Cannot generate attribute: " + nameFunctionPair[0] + " --> " + nameFunctionPair[1]);
            }
            this.checkForStop();
        }
        if (!keepAll) {
            for (Attribute oldAttribute : oldAttributes) {
                exampleSet.getAttributes().remove(oldAttribute);
            }
        }
        return exampleSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterType type = new ParameterTypeFile(PARAMETER_FILENAME, "Create the attributes listed in this file (written by an AttributeConstructionsWriter).", "att", true);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeList(PARAMETER_FUNCTIONS, "List of functions to generate.", (ParameterType)new ParameterTypeString("attribute_name", "The name of the generated attribtue."), (ParameterType)new ParameterTypeString("function", "Function and arguments to use for generation."));
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeBoolean(PARAMETER_KEEP_ALL, "If set to true, all the original attributes are kept, otherwise they are removed from the example set.", false));
        return types;
    }
}

