/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.construction;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.set.AttributeWeightedExampleSet;
import com.rapidminer.operator.features.construction.ExampleSetBasedIndividual;
import com.rapidminer.operator.features.construction.ExampleSetBasedIndividualOperator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;

public class ExampleSetBasedSelectionMutation
extends ExampleSetBasedIndividualOperator {
    private double probability;
    private Random random;
    private int minNumber;
    private int maxNumber;
    private int exactNumber;

    public ExampleSetBasedSelectionMutation(double probability, Random random, int minNumber, int maxNumber, int exactNumber) {
        this.probability = probability;
        this.random = random;
        this.minNumber = minNumber;
        this.maxNumber = maxNumber;
        this.exactNumber = exactNumber;
    }

    @Override
    public List<ExampleSetBasedIndividual> operate(ExampleSetBasedIndividual individual) {
        LinkedList<ExampleSetBasedIndividual> l = new LinkedList<ExampleSetBasedIndividual>();
        AttributeWeightedExampleSet clone = (AttributeWeightedExampleSet)individual.getExampleSet().clone();
        double prob = this.probability < 0.0 ? 1.0 / (double)clone.getAttributes().size() : this.probability;
        for (Attribute attribute : clone.getAttributes()) {
            if (!(this.random.nextDouble() < prob)) continue;
            clone.flipAttributeUsed(attribute);
        }
        int numberOfFeatures = clone.getNumberOfUsedAttributes();
        if (numberOfFeatures > 0) {
            if (this.exactNumber > 0) {
                if (numberOfFeatures == this.exactNumber) {
                    l.add(new ExampleSetBasedIndividual(clone));
                }
            } else if ((this.maxNumber < 1 || numberOfFeatures <= this.maxNumber) && numberOfFeatures >= this.minNumber) {
                l.add(new ExampleSetBasedIndividual(clone));
            }
        }
        l.add(individual);
        return l;
    }
}

