/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.construction;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.set.AttributeWeightedExampleSet;
import com.rapidminer.operator.features.construction.ExampleSetBasedIndividual;
import com.rapidminer.operator.features.construction.ExampleSetBasedPopulation;
import com.rapidminer.operator.features.construction.ExampleSetBasedPopulationOperator;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Random;

public class ExampleSetBasedSelectionCrossover
implements ExampleSetBasedPopulationOperator {
    public static final String[] CROSSOVER_TYPES = new String[]{"one_point", "uniform", "shuffle"};
    public static final int ONE_POINT = 0;
    public static final int UNIFORM = 1;
    public static final int SHUFFLE = 2;
    private int type;
    private double prob;
    private Random random;
    private int minNumber;
    private int maxNumber;
    private int exactNumber;

    public ExampleSetBasedSelectionCrossover(int type, double prob, Random random, int minNumber, int maxNumber, int exactNumber) {
        this.prob = prob;
        this.type = type;
        this.random = random;
        this.minNumber = minNumber;
        this.maxNumber = maxNumber;
        this.exactNumber = exactNumber;
    }

    @Override
    public boolean performOperation(int generation) {
        return true;
    }

    public int getType() {
        return this.type;
    }

    public void crossover(AttributeWeightedExampleSet es1, AttributeWeightedExampleSet es2) {
        switch (this.type) {
            case 0: {
                int n = 1 + this.random.nextInt(es1.getAttributes().size() - 1);
                int counter = 0;
                for (Attribute attribute : es1.getAttributes()) {
                    if (counter >= n) {
                        boolean dummy = es1.isAttributeUsed(attribute);
                        es1.setAttributeUsed(attribute, es2.isAttributeUsed(attribute));
                        es2.setAttributeUsed(attribute, dummy);
                    }
                    ++counter;
                }
                break;
            }
            case 1: {
                boolean[] swap = new boolean[es1.getAttributes().size()];
                for (int i = 0; i < swap.length; ++i) {
                    swap[i] = this.random.nextBoolean();
                }
                this.swapAttributes(es1, es2, swap);
                break;
            }
            case 2: {
                boolean[] swap = new boolean[es1.getAttributes().size()];
                ArrayList<Integer> indices = new ArrayList<Integer>();
                for (int i = 0; i < swap.length; ++i) {
                    indices.add(i);
                }
                if (indices.size() > 0) {
                    int toSwap = this.random.nextInt(indices.size() - 1) + 1;
                    for (int i = 0; i < toSwap; ++i) {
                        swap[((Integer)indices.remove((int)this.random.nextInt((int)indices.size()))).intValue()] = true;
                    }
                }
                this.swapAttributes(es1, es2, swap);
                break;
            }
        }
    }

    private void swapAttributes(AttributeWeightedExampleSet es1, AttributeWeightedExampleSet es2, boolean[] swap) {
        int index = 0;
        for (Attribute attribute : es1.getAttributes()) {
            if (!swap[index++]) continue;
            boolean dummy = es1.isAttributeUsed(attribute);
            es1.setAttributeUsed(attribute, es2.isAttributeUsed(attribute));
            es2.setAttributeUsed(attribute, dummy);
        }
    }

    @Override
    public void operate(ExampleSetBasedPopulation population) {
        if (population.getNumberOfIndividuals() < 2) {
            return;
        }
        LinkedList<AttributeWeightedExampleSet> matingPool = new LinkedList<AttributeWeightedExampleSet>();
        for (int i = 0; i < population.getNumberOfIndividuals(); ++i) {
            matingPool.add((AttributeWeightedExampleSet)population.get(i).getExampleSet().clone());
        }
        LinkedList<ExampleSetBasedIndividual> l = new LinkedList<ExampleSetBasedIndividual>();
        while (matingPool.size() > 1) {
            AttributeWeightedExampleSet p1 = (AttributeWeightedExampleSet)matingPool.remove(this.random.nextInt(matingPool.size()));
            AttributeWeightedExampleSet p2 = (AttributeWeightedExampleSet)matingPool.remove(this.random.nextInt(matingPool.size()));
            if (!(this.random.nextDouble() < this.prob)) continue;
            this.crossover(p1, p2);
            int numberOfFeatures = p1.getNumberOfUsedAttributes();
            if (numberOfFeatures > 0) {
                if (this.exactNumber > 0) {
                    if (numberOfFeatures == this.exactNumber) {
                        l.add(new ExampleSetBasedIndividual(p1));
                    }
                } else if ((this.maxNumber < 1 || numberOfFeatures <= this.maxNumber) && numberOfFeatures >= this.minNumber) {
                    l.add(new ExampleSetBasedIndividual(p1));
                }
            }
            if ((numberOfFeatures = p2.getNumberOfUsedAttributes()) <= 0) continue;
            if (this.exactNumber > 0) {
                if (numberOfFeatures != this.exactNumber) continue;
                l.add(new ExampleSetBasedIndividual(p2));
                continue;
            }
            if (this.maxNumber >= 1 && numberOfFeatures > this.maxNumber || numberOfFeatures < this.minNumber) continue;
            l.add(new ExampleSetBasedIndividual(p2));
        }
        population.addAllIndividuals(l);
    }
}

