/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.construction;

import com.rapidminer.example.set.AttributeWeightedExampleSet;
import com.rapidminer.operator.features.construction.ExampleSetBasedIndividual;
import com.rapidminer.operator.performance.PerformanceVector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.NoSuchElementException;

public class ExampleSetBasedPopulation {
    public static final Comparator<ExampleSetBasedIndividual> PERFORMANCE_COMPARATOR = new Comparator<ExampleSetBasedIndividual>(){

        @Override
        public int compare(ExampleSetBasedIndividual i1, ExampleSetBasedIndividual i2) {
            PerformanceVector p1 = i1.getPerformance();
            PerformanceVector p2 = i2.getPerformance();
            return p1.compareTo(p2);
        }
    };
    private ArrayList<ExampleSetBasedIndividual> individuals = new ArrayList();
    private int generation = 0;
    private int generationOfLastImproval = 0;
    private ExampleSetBasedIndividual bestEver;
    private PerformanceVector bestPerformanceEver;
    private ExampleSetBasedIndividual currentBest;
    private PerformanceVector currentBestPerformance;

    public void clear() {
        this.individuals.clear();
    }

    public void add(ExampleSetBasedIndividual individual) {
        this.individuals.add(individual);
    }

    public void addAllIndividuals(Collection<ExampleSetBasedIndividual> newIndividuals) {
        this.individuals.addAll(newIndividuals);
    }

    public void remove(ExampleSetBasedIndividual individual) {
        this.individuals.remove(individual);
    }

    public void remove(int i) {
        this.individuals.remove(i);
    }

    public ExampleSetBasedIndividual get(int i) {
        return this.individuals.get(i);
    }

    public int getNumberOfIndividuals() {
        return this.individuals.size();
    }

    public boolean empty() {
        return this.individuals.size() == 0;
    }

    public void nextGeneration() {
        ++this.generation;
    }

    public int getGeneration() {
        return this.generation;
    }

    public int getGenerationsWithoutImproval() {
        return this.generation - this.generationOfLastImproval;
    }

    public void updateEvaluation() {
        this.currentBest = this.searchBest();
        PerformanceVector performanceVector = this.currentBestPerformance = this.currentBest == null ? null : this.currentBest.getPerformance();
        if (this.bestEver == null || this.currentBest != null && this.currentBestPerformance.compareTo(this.bestPerformanceEver) > 0) {
            this.bestEver = new ExampleSetBasedIndividual((AttributeWeightedExampleSet)this.currentBest.getExampleSet().clone());
            this.bestEver.setPerformance(this.currentBest.getPerformance());
            this.bestPerformanceEver = this.bestEver.getPerformance();
            this.generationOfLastImproval = this.generation;
        }
    }

    private ExampleSetBasedIndividual searchBest() {
        try {
            return Collections.max(this.individuals, PERFORMANCE_COMPARATOR);
        }
        catch (NullPointerException e) {
            return null;
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    public PerformanceVector getBestPerformanceEver() {
        return this.bestPerformanceEver;
    }

    public ExampleSetBasedIndividual getBestIndividualEver() {
        return this.bestEver;
    }

    public ExampleSetBasedIndividual getCurrentBest() {
        return this.currentBest;
    }

    public PerformanceVector getCurrentBestPerformance() {
        return this.currentBestPerformance;
    }

    public void sort() {
        Collections.sort(this.individuals, PERFORMANCE_COMPARATOR);
    }

    public String toString() {
        StringBuffer s = new StringBuffer("Generation: " + this.generation + ",size: " + this.getNumberOfIndividuals() + ", individual sizes: [");
        for (int i = 0; i < this.getNumberOfIndividuals(); ++i) {
            if (i > 0) {
                s.append(",");
            }
            s.append(this.get(i).getExampleSet().getNumberOfUsedAttributes());
        }
        s.append("]");
        return s.toString();
    }
}

