/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.construction;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.AttributeWeightedExampleSet;
import com.rapidminer.example.set.SimpleExampleSet;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.example.table.DataRowFactory;
import com.rapidminer.example.table.DataRowReader;
import com.rapidminer.example.table.ExampleTable;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.generator.GenerationException;
import com.rapidminer.operator.features.construction.ExampleSetBasedIndividual;
import com.rapidminer.operator.features.construction.ExampleSetBasedIndividualOperator;
import com.rapidminer.tools.RandomGenerator;
import com.rapidminer.tools.math.function.ExpressionParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class EquivalentAttributeRemoval
extends ExampleSetBasedIndividualOperator {
    private int numberOfSamples = 10;
    private double epsilon = 5.0E-5;
    private boolean recalculateAttributeStatistics = false;
    private RandomGenerator random;

    public EquivalentAttributeRemoval(int numberOfSamples, double epsilon, boolean recalculateAttributeStatistics, RandomGenerator random) {
        this.numberOfSamples = numberOfSamples;
        this.epsilon = epsilon;
        this.recalculateAttributeStatistics = recalculateAttributeStatistics;
        this.random = random;
    }

    @Override
    public List<ExampleSetBasedIndividual> operate(ExampleSetBasedIndividual individual) {
        AttributeWeightedExampleSet exampleSet = individual.getExampleSet();
        if (this.recalculateAttributeStatistics) {
            exampleSet.recalculateAllAttributeStatistics();
        }
        Attribute[] allAttributes = exampleSet.getExampleTable().getAttributes();
        ArrayList<Attribute> simpleAttributesList = new ArrayList<Attribute>();
        for (int i = 0; i < allAttributes.length; ++i) {
            if (allAttributes[i] == null || !allAttributes[i].getConstruction().equals(allAttributes[i].getName())) continue;
            simpleAttributesList.add(allAttributes[i]);
        }
        HashMap<String, Attribute> removeMap = new HashMap<String, Attribute>();
        Attribute[] attributeArray = exampleSet.getAttributes().createRegularAttributeArray();
        for (int i = 0; i < attributeArray.length; ++i) {
            for (int j = i + 1; j < attributeArray.length; ++j) {
                Attribute att1 = attributeArray[i];
                Attribute att2 = attributeArray[j];
                if (att1.getConstruction().equals(att2.getConstruction())) {
                    removeMap.put(att2.getName(), att2);
                    continue;
                }
                MemoryExampleTable exampleTable = new MemoryExampleTable(simpleAttributesList, new DataRowFactory(0, '.'), this.numberOfSamples);
                EquivalentAttributeRemoval.fillTableWithRandomValues(exampleTable, exampleSet, this.random);
                SimpleExampleSet randomSet = new SimpleExampleSet((ExampleTable)exampleTable, simpleAttributesList);
                try {
                    int depth2;
                    ExpressionParser parser = new ExpressionParser(true);
                    Attribute test1 = parser.addAttribute(randomSet, "test1", att1.getConstruction());
                    Attribute test2 = parser.addAttribute(randomSet, "test2", att2.getConstruction());
                    if (!this.equivalent(randomSet, test1, test2)) continue;
                    int depth1 = att1.getConstruction().length();
                    if (depth1 > (depth2 = att2.getConstruction().length())) {
                        removeMap.put(att1.getName(), att1);
                        exampleSet.getLog().log("Removing attribute " + att1.getName() + "=" + att1.getConstruction() + " which is equivalent to " + att2.getName() + "=" + att2.getConstruction() + ".");
                        continue;
                    }
                    removeMap.put(att2.getName(), att2);
                    exampleSet.getLog().log("Removing attribute " + att2.getName() + "=" + att2.getConstruction() + " which is equivalent to " + att1.getName() + "=" + att1.getConstruction() + ".");
                    continue;
                }
                catch (GenerationException e) {
                    exampleSet.getLog().logWarning("Cannot generate test attribute: " + e.getMessage() + ". We just keep both attributes for sure...");
                }
            }
        }
        for (Attribute attribute : removeMap.values()) {
            exampleSet.getAttributes().remove(attribute);
        }
        LinkedList<ExampleSetBasedIndividual> l = new LinkedList<ExampleSetBasedIndividual>();
        l.add(new ExampleSetBasedIndividual(exampleSet));
        return l;
    }

    private boolean equivalent(ExampleSet exampleSet, Attribute test1, Attribute test2) {
        if (exampleSet.getAttributes().size() < 2) {
            return true;
        }
        for (Example example : exampleSet) {
            double value2;
            double value1 = example.getValue(test1);
            if (!(Math.abs(value1 - (value2 = example.getValue(test2))) > this.epsilon)) continue;
            return false;
        }
        return true;
    }

    private static void fillTableWithRandomValues(ExampleTable exampleTable, ExampleSet baseSet, RandomGenerator random) {
        DataRowReader reader = exampleTable.getDataRowReader();
        Attribute[] attributes = exampleTable.getAttributes();
        while (reader.hasNext()) {
            DataRow dataRow = (DataRow)reader.next();
            for (int i = 0; i < attributes.length; ++i) {
                if (attributes[i] == null) continue;
                if (!attributes[i].isNominal()) {
                    double min = baseSet.getStatistics(attributes[i], "minimum");
                    double max = baseSet.getStatistics(attributes[i], "maximum");
                    if (max > min) {
                        dataRow.set(attributes[i], random.nextDoubleInRange(min, max));
                        continue;
                    }
                    dataRow.set(attributes[i], random.nextDouble() * 2.0 - 1.0);
                    continue;
                }
                dataRow.set(attributes[i], 0.0);
            }
        }
    }
}

