/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.construction;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.generator.FeatureGenerator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.features.construction.DirectedGeneratingMutation;
import com.rapidminer.operator.features.construction.ExampleSetBasedPopulationOperator;
import com.rapidminer.operator.features.construction.YAGGA2;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeString;
import java.util.List;

public class DirectedGGA
extends YAGGA2 {
    public static final String PARAMETER_MAX_GENERATED = "max_generated";
    public static final String PARAMETER_MAX_ORIGINAL = "max_original";

    public DirectedGGA(OperatorDescription description) {
        super(description);
    }

    @Override
    protected ExampleSetBasedPopulationOperator getMutationPopulationOperator(ExampleSet eSet) throws OperatorException {
        List<FeatureGenerator> generators = this.getGenerators();
        if (generators.size() == 0) {
            this.logWarning("No FeatureGenerators specified for " + this.getName() + ".");
        }
        Attribute[] attributes = eSet.getAttributes().createRegularAttributeArray();
        return new DirectedGeneratingMutation(attributes, this.getParameterAsDouble("p_mutation"), generators, this.getParameterAsInt(PARAMETER_MAX_GENERATED), this.getParameterAsInt(PARAMETER_MAX_ORIGINAL), this.getParameterAsString("unused_functions").split(" "), this.getRandom());
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeInt(PARAMETER_MAX_GENERATED, "The maximum number of generated attributes per generation.", 1, Integer.MAX_VALUE, 2));
        types.add(new ParameterTypeInt(PARAMETER_MAX_ORIGINAL, "The maximum number of original attributes added per generation.", 1, Integer.MAX_VALUE, 2));
        types.add(new ParameterTypeString("unused_functions", "Space separated list of functions which are not allowed in arguments for attribute construction."));
        return types;
    }
}

