/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.construction;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.set.AttributeWeightedExampleSet;
import com.rapidminer.generator.ConstantGenerator;
import com.rapidminer.generator.FeatureGenerator;
import com.rapidminer.operator.features.construction.ExampleSetBasedIndividual;
import com.rapidminer.operator.features.construction.ExampleSetBasedIndividualOperator;
import com.rapidminer.tools.RandomGenerator;
import java.util.LinkedList;
import java.util.List;

public class ConstantGeneration
extends ExampleSetBasedIndividualOperator {
    private double prob;
    private RandomGenerator random;

    public ConstantGeneration(double prob, RandomGenerator random) {
        this.prob = prob;
        this.random = random;
    }

    @Override
    public List<ExampleSetBasedIndividual> operate(ExampleSetBasedIndividual individual) throws Exception {
        AttributeWeightedExampleSet exampleSet = individual.getExampleSet();
        if (this.random.nextDouble() < this.prob) {
            ConstantGenerator generator = new ConstantGenerator(this.random.nextDoubleInRange(-10.0, 10.0));
            LinkedList<FeatureGenerator> generatorList = new LinkedList<FeatureGenerator>();
            generatorList.add(generator);
            List<Attribute> newAttributes = FeatureGenerator.generateAll(exampleSet.getExampleTable(), generatorList);
            for (Attribute newAttribute : newAttributes) {
                exampleSet.getAttributes().addRegular(newAttribute);
            }
        }
        LinkedList<ExampleSetBasedIndividual> result = new LinkedList<ExampleSetBasedIndividual>();
        result.add(new ExampleSetBasedIndividual(exampleSet));
        return result;
    }
}

