/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.construction;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.generator.AbsoluteValueGenerator;
import com.rapidminer.generator.BasicArithmeticOperationGenerator;
import com.rapidminer.generator.ExponentialFunctionGenerator;
import com.rapidminer.generator.FeatureGenerator;
import com.rapidminer.generator.FloorCeilGenerator;
import com.rapidminer.generator.MinMaxGenerator;
import com.rapidminer.generator.PowerGenerator;
import com.rapidminer.generator.ReciprocalValueGenerator;
import com.rapidminer.generator.SquareRootGenerator;
import com.rapidminer.generator.TrigonometricFunctionGenerator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.features.construction.AbstractFeatureConstruction;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.math.MathFunctions;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class CompleteFeatureGenerationOperator
extends AbstractFeatureConstruction {
    public static final String PARAMETER_KEEP_ALL = "keep_all";
    public static final String PARAMETER_USE_PLUS = "use_plus";
    public static final String PARAMETER_USE_DIFF = "use_diff";
    public static final String PARAMETER_USE_MULT = "use_mult";
    public static final String PARAMETER_USE_DIV = "use_div";
    public static final String PARAMETER_USE_RECIPROCALS = "use_reciprocals";
    public static final String PARAMETER_USE_SQUARE_ROOTS = "use_square_roots";
    public static final String PARAMETER_USE_POWER_FUNCTIONS = "use_power_functions";
    public static final String PARAMETER_USE_SIN = "use_sin";
    public static final String PARAMETER_USE_COS = "use_cos";
    public static final String PARAMETER_USE_TAN = "use_tan";
    public static final String PARAMETER_USE_ATAN = "use_atan";
    public static final String PARAMETER_USE_EXP = "use_exp";
    public static final String PARAMETER_USE_LOG = "use_log";
    public static final String PARAMETER_USE_ABSOLUTE_VALUES = "use_absolute_values";
    public static final String PARAMETER_USE_MIN = "use_min";
    public static final String PARAMETER_USE_MAX = "use_max";
    public static final String PARAMETER_USE_CEIL = "use_ceil";
    public static final String PARAMETER_USE_FLOOR = "use_floor";
    public static final String PARAMETER_USE_ROUNDED = "use_rounded";

    public CompleteFeatureGenerationOperator(OperatorDescription description) {
        super(description);
    }

    @Override
    protected MetaData modifyMetaData(ExampleSetMetaData metaData) throws UndefinedParameterError {
        int numberOfNumerical = 0;
        for (AttributeMetaData amd : metaData.getAllAttributes()) {
            if (!amd.isNumerical() || amd.isSpecial()) continue;
            ++numberOfNumerical;
        }
        if (!this.getParameterAsBoolean(PARAMETER_KEEP_ALL)) {
            metaData.clearRegular();
        }
        int numberOfAdditionalAttributes = 0;
        int commutativeNonSelfapplicable = MathFunctions.factorial(numberOfNumerical - 1);
        int commutativeSelfapplicable = MathFunctions.factorial(numberOfNumerical);
        int nonCommuatativeSelfApplicable = numberOfNumerical * numberOfNumerical;
        int nonCommuatativeNonSelfApplicable = numberOfNumerical * numberOfNumerical;
        if (this.getParameterAsBoolean(PARAMETER_USE_PLUS)) {
            numberOfAdditionalAttributes += commutativeNonSelfapplicable;
        }
        if (this.getParameterAsBoolean(PARAMETER_USE_DIFF)) {
            numberOfAdditionalAttributes += nonCommuatativeNonSelfApplicable;
        }
        if (this.getParameterAsBoolean(PARAMETER_USE_MULT)) {
            numberOfAdditionalAttributes += commutativeSelfapplicable;
        }
        if (this.getParameterAsBoolean(PARAMETER_USE_DIV)) {
            numberOfAdditionalAttributes += nonCommuatativeNonSelfApplicable;
        }
        if (this.getParameterAsBoolean(PARAMETER_USE_RECIPROCALS)) {
            numberOfAdditionalAttributes += numberOfNumerical;
        }
        if (this.getParameterAsBoolean(PARAMETER_USE_SQUARE_ROOTS)) {
            numberOfAdditionalAttributes += numberOfNumerical;
        }
        if (this.getParameterAsBoolean(PARAMETER_USE_POWER_FUNCTIONS)) {
            numberOfAdditionalAttributes += nonCommuatativeSelfApplicable;
        }
        if (this.getParameterAsBoolean(PARAMETER_USE_SIN)) {
            numberOfAdditionalAttributes += numberOfNumerical;
        }
        if (this.getParameterAsBoolean(PARAMETER_USE_COS)) {
            numberOfAdditionalAttributes += numberOfNumerical;
        }
        if (this.getParameterAsBoolean(PARAMETER_USE_TAN)) {
            numberOfAdditionalAttributes += numberOfNumerical;
        }
        if (this.getParameterAsBoolean(PARAMETER_USE_ATAN)) {
            numberOfAdditionalAttributes += numberOfNumerical;
        }
        if (this.getParameterAsBoolean(PARAMETER_USE_EXP)) {
            numberOfAdditionalAttributes += numberOfNumerical;
        }
        if (this.getParameterAsBoolean(PARAMETER_USE_LOG)) {
            numberOfAdditionalAttributes += numberOfNumerical;
        }
        if (this.getParameterAsBoolean(PARAMETER_USE_ABSOLUTE_VALUES)) {
            numberOfAdditionalAttributes += numberOfNumerical;
        }
        if (this.getParameterAsBoolean(PARAMETER_USE_MIN)) {
            numberOfAdditionalAttributes += commutativeNonSelfapplicable;
        }
        if (this.getParameterAsBoolean(PARAMETER_USE_MAX)) {
            numberOfAdditionalAttributes += commutativeNonSelfapplicable;
        }
        if (this.getParameterAsBoolean(PARAMETER_USE_CEIL)) {
            numberOfAdditionalAttributes += numberOfNumerical;
        }
        if (this.getParameterAsBoolean(PARAMETER_USE_FLOOR)) {
            numberOfAdditionalAttributes += numberOfNumerical;
        }
        if (this.getParameterAsBoolean(PARAMETER_USE_ROUNDED)) {
            numberOfAdditionalAttributes += numberOfNumerical;
        }
        for (int i = 0; i < numberOfAdditionalAttributes; ++i) {
            if (i == 0) {
                metaData.addAttribute(new AttributeMetaData("gensym", 4));
                continue;
            }
            metaData.addAttribute(new AttributeMetaData("gensym" + i, 4));
        }
        return metaData;
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        FeatureGenerator.setSelectionMode(1);
        List<FeatureGenerator> generators = this.getGenerators();
        LinkedList<FeatureGenerator> generatorList = new LinkedList<FeatureGenerator>();
        for (FeatureGenerator generator : generators) {
            List<Attribute[]> inputAttributes = generator.getInputCandidates(exampleSet, new String[0]);
            for (Attribute[] args : inputAttributes) {
                FeatureGenerator newGenerator = generator.newInstance();
                newGenerator.setArguments(args);
                generatorList.add(newGenerator);
            }
        }
        if (!this.getParameterAsBoolean(PARAMETER_KEEP_ALL)) {
            exampleSet.getAttributes().clearRegular();
        }
        List<Attribute> newAttributes = FeatureGenerator.generateAll(exampleSet.getExampleTable(), generatorList);
        for (Attribute newAttribute : newAttributes) {
            exampleSet.getAttributes().addRegular(newAttribute);
        }
        return exampleSet;
    }

    private List<FeatureGenerator> getGenerators() {
        ArrayList<FeatureGenerator> generators = new ArrayList<FeatureGenerator>();
        if (this.getParameterAsBoolean(PARAMETER_USE_PLUS)) {
            generators.add(new BasicArithmeticOperationGenerator(0));
        }
        if (this.getParameterAsBoolean(PARAMETER_USE_DIFF)) {
            generators.add(new BasicArithmeticOperationGenerator(1));
        }
        if (this.getParameterAsBoolean(PARAMETER_USE_MULT)) {
            generators.add(new BasicArithmeticOperationGenerator(2));
        }
        if (this.getParameterAsBoolean(PARAMETER_USE_DIV)) {
            generators.add(new BasicArithmeticOperationGenerator(3));
        }
        if (this.getParameterAsBoolean(PARAMETER_USE_RECIPROCALS)) {
            generators.add(new ReciprocalValueGenerator());
        }
        if (this.getParameterAsBoolean(PARAMETER_USE_SQUARE_ROOTS)) {
            generators.add(new SquareRootGenerator());
        }
        if (this.getParameterAsBoolean(PARAMETER_USE_POWER_FUNCTIONS)) {
            generators.add(new PowerGenerator());
        }
        if (this.getParameterAsBoolean(PARAMETER_USE_SIN)) {
            generators.add(new TrigonometricFunctionGenerator(0));
        }
        if (this.getParameterAsBoolean(PARAMETER_USE_COS)) {
            generators.add(new TrigonometricFunctionGenerator(1));
        }
        if (this.getParameterAsBoolean(PARAMETER_USE_TAN)) {
            generators.add(new TrigonometricFunctionGenerator(2));
        }
        if (this.getParameterAsBoolean(PARAMETER_USE_ATAN)) {
            generators.add(new TrigonometricFunctionGenerator(3));
        }
        if (this.getParameterAsBoolean(PARAMETER_USE_EXP)) {
            generators.add(new ExponentialFunctionGenerator(0));
        }
        if (this.getParameterAsBoolean(PARAMETER_USE_LOG)) {
            generators.add(new ExponentialFunctionGenerator(1));
        }
        if (this.getParameterAsBoolean(PARAMETER_USE_ABSOLUTE_VALUES)) {
            generators.add(new AbsoluteValueGenerator());
        }
        if (this.getParameterAsBoolean(PARAMETER_USE_MIN)) {
            generators.add(new MinMaxGenerator(0));
        }
        if (this.getParameterAsBoolean(PARAMETER_USE_MAX)) {
            generators.add(new MinMaxGenerator(1));
        }
        if (this.getParameterAsBoolean(PARAMETER_USE_CEIL)) {
            generators.add(new FloorCeilGenerator(1));
        }
        if (this.getParameterAsBoolean(PARAMETER_USE_FLOOR)) {
            generators.add(new FloorCeilGenerator(0));
        }
        if (this.getParameterAsBoolean(PARAMETER_USE_ROUNDED)) {
            generators.add(new FloorCeilGenerator(2));
        }
        return generators;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeBoolean(PARAMETER_KEEP_ALL, "If set to true, all the original attributes are kept, otherwise they are removed from the example set.", true, false));
        types.add(new ParameterTypeBoolean(PARAMETER_USE_PLUS, "Generate sums.", false, false));
        types.add(new ParameterTypeBoolean(PARAMETER_USE_DIFF, "Generate differences.", false, false));
        types.add(new ParameterTypeBoolean(PARAMETER_USE_MULT, "Generate products.", false, false));
        types.add(new ParameterTypeBoolean(PARAMETER_USE_DIV, "Generate quotients.", false, false));
        types.add(new ParameterTypeBoolean(PARAMETER_USE_RECIPROCALS, "Generate reciprocal values.", false, false));
        types.add(new ParameterTypeBoolean(PARAMETER_USE_SQUARE_ROOTS, "Generate square root values.", false, false));
        types.add(new ParameterTypeBoolean(PARAMETER_USE_POWER_FUNCTIONS, "Generate the power of one attribute and another.", false, false));
        types.add(new ParameterTypeBoolean(PARAMETER_USE_SIN, "Generate sinus.", false, false));
        types.add(new ParameterTypeBoolean(PARAMETER_USE_COS, "Generate cosinus.", false, false));
        types.add(new ParameterTypeBoolean(PARAMETER_USE_TAN, "Generate tangens.", false, false));
        types.add(new ParameterTypeBoolean(PARAMETER_USE_ATAN, "Generate arc tangens.", false, false));
        types.add(new ParameterTypeBoolean(PARAMETER_USE_EXP, "Generate exponential functions.", false, false));
        types.add(new ParameterTypeBoolean(PARAMETER_USE_LOG, "Generate logarithmic functions.", false, false));
        types.add(new ParameterTypeBoolean(PARAMETER_USE_ABSOLUTE_VALUES, "Generate absolute values.", false, false));
        types.add(new ParameterTypeBoolean(PARAMETER_USE_MIN, "Generate minimum values.", false, false));
        types.add(new ParameterTypeBoolean(PARAMETER_USE_MAX, "Generate maximum values.", false, false));
        types.add(new ParameterTypeBoolean(PARAMETER_USE_CEIL, "Generate ceil values.", false, false));
        types.add(new ParameterTypeBoolean(PARAMETER_USE_FLOOR, "Generate floor values.", false, false));
        types.add(new ParameterTypeBoolean(PARAMETER_USE_ROUNDED, "Generate rounded values.", false, false));
        return types;
    }
}

