/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.construction;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.generator.GenerationException;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.features.construction.AbstractFeatureConstruction;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeExpression;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.math.function.ExpressionParser;
import java.util.LinkedList;
import java.util.List;

public class AttributeConstruction
extends AbstractFeatureConstruction {
    public static final String PARAMETER_FUNCTIONS = "function_descriptions";
    public static final String PARAMETER_USE_STANDARD_CONSTANTS = "use_standard_constants";
    public static final String PARAMETER_KEEP_ALL = "keep_all";

    public AttributeConstruction(OperatorDescription description) {
        super(description);
    }

    @Override
    protected MetaData modifyMetaData(ExampleSetMetaData metaData) {
        ExpressionParser parser = new ExpressionParser(this.getParameterAsBoolean(PARAMETER_USE_STANDARD_CONSTANTS), this.getProcess());
        try {
            for (String[] nameFunctionPair : this.getParameterList(PARAMETER_FUNCTIONS)) {
                String name = nameFunctionPair[0];
                String function = nameFunctionPair[1];
                parser.addAttributeMetaData(metaData, name, function);
            }
        }
        catch (UndefinedParameterError undefinedParameterError) {
            // empty catch block
        }
        return metaData;
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        LinkedList<Attribute> originalAttributes = new LinkedList<Attribute>();
        for (Attribute attribute : exampleSet.getAttributes()) {
            originalAttributes.add(attribute);
        }
        ExpressionParser parser = new ExpressionParser(this.getParameterAsBoolean(PARAMETER_USE_STANDARD_CONSTANTS), this.getProcess());
        for (String[] nameFunctionPair : this.getParameterList(PARAMETER_FUNCTIONS)) {
            String name = nameFunctionPair[0];
            String function = nameFunctionPair[1];
            try {
                parser.addAttribute(exampleSet, name, function);
            }
            catch (GenerationException e) {
                throw new UserError((Operator)this, (Throwable)e, 108, e.getMessage());
            }
            this.checkForStop();
        }
        if (!this.getParameterAsBoolean(PARAMETER_KEEP_ALL)) {
            for (Attribute attribute : originalAttributes) {
                exampleSet.getAttributes().remove(attribute);
            }
        }
        return exampleSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeList type = new ParameterTypeList(PARAMETER_FUNCTIONS, "List of functions to generate.", (ParameterType)new ParameterTypeString("attribute_name", "Specifies the name of the constructed attribute"), (ParameterType)new ParameterTypeExpression("function_expressions", "Function and arguments to use for generation.", this.getInputPort()));
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeBoolean(PARAMETER_USE_STANDARD_CONSTANTS, "Indicates if standard constants like e or pi should be available.", true));
        types.add(new ParameterTypeBoolean(PARAMETER_KEEP_ALL, "If set to true, all the original attributes are kept, otherwise they are removed from the example set.", true));
        return types;
    }
}

