/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.construction;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.features.construction.AbstractFeatureConstruction;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MDInteger;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.SimpleMetaDataError;
import com.rapidminer.operator.tools.AttributeSubsetSelector;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.math.function.aggregation.AbstractAggregationFunction;
import com.rapidminer.tools.math.function.aggregation.AggregationFunction;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Set;

public class AttributeAggregationOperator
extends AbstractFeatureConstruction {
    public static final String PARAMETER_ATTRIBUTE_NAME = "attribute_name";
    public static final String PARAMETER_AGGREGATION_FUNCTION = "aggregation_function";
    public static final String PARAMETER_IGNORE_MISSINGS = "ignore_missings";
    public static final String PARAMETER_KEEP_ALL = "keep_all";

    public AttributeAggregationOperator(OperatorDescription description) {
        super(description);
    }

    @Override
    protected MetaData modifyMetaData(ExampleSetMetaData metaData) {
        try {
            AttributeMetaData newAMD = new AttributeMetaData(this.getParameterAsString(PARAMETER_ATTRIBUTE_NAME), 4);
            AttributeSubsetSelector selector = new AttributeSubsetSelector(this, this.getExampleSetInputPort());
            String functionName = AbstractAggregationFunction.KNOWN_AGGREGATION_FUNCTION_NAMES[this.getParameterAsInt(PARAMETER_AGGREGATION_FUNCTION)];
            boolean ignoreMissings = this.getParameterAsBoolean(PARAMETER_IGNORE_MISSINGS);
            AggregationFunction aggregationFunction = null;
            try {
                aggregationFunction = AbstractAggregationFunction.createAggregationFunction(functionName, ignoreMissings);
                int numberOfMissings = 0;
                for (AttributeMetaData amd : selector.getMetaDataSubset(metaData, false).getAllAttributes()) {
                    if (!aggregationFunction.supportsAttribute(amd)) {
                        this.getExampleSetInputPort().addError(new SimpleMetaDataError(ProcessSetupError.Severity.ERROR, (Port)this.getExampleSetInputPort(), "exampleset.parameters.attribute_must_be_numerical", amd.getName(), PARAMETER_AGGREGATION_FUNCTION, functionName));
                    }
                    if (!amd.getNumberOfMissingValues().isKnown()) continue;
                    numberOfMissings = Math.max(numberOfMissings, (Integer)amd.getNumberOfMissingValues().getValue());
                }
                newAMD.setNumberOfMissingValues(new MDInteger(numberOfMissings));
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (ClassNotFoundException e) {
            }
            catch (NoSuchMethodException e) {
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
            metaData.addAttribute(newAMD);
        }
        catch (UndefinedParameterError undefinedParameterError) {
            // empty catch block
        }
        return metaData;
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        AttributeSubsetSelector selector = new AttributeSubsetSelector(this, this.getExampleSetInputPort());
        Set<Attribute> attributes = selector.getAttributeSubset(exampleSet, false);
        String functionName = AbstractAggregationFunction.KNOWN_AGGREGATION_FUNCTION_NAMES[this.getParameterAsInt(PARAMETER_AGGREGATION_FUNCTION)];
        boolean ignoreMissings = this.getParameterAsBoolean(PARAMETER_IGNORE_MISSINGS);
        AggregationFunction aggregationFunction = null;
        try {
            aggregationFunction = AbstractAggregationFunction.createAggregationFunction(functionName, ignoreMissings);
        }
        catch (InstantiationException e) {
            throw new UserError((Operator)this, 904, functionName, e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new UserError((Operator)this, 904, functionName, e.getMessage());
        }
        catch (ClassNotFoundException e) {
            throw new UserError((Operator)this, 904, functionName, e.getMessage());
        }
        catch (NoSuchMethodException e) {
            throw new UserError((Operator)this, 904, functionName, e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new UserError((Operator)this, 904, functionName, e.getMessage());
        }
        int valueType = 0;
        for (Attribute attribute : attributes) {
            if (valueType == 0) {
                valueType = attribute.isNominal() || attribute.isNumerical() ? 2 : attribute.getValueType();
            }
            if (aggregationFunction.supportsAttribute(attribute)) continue;
            throw new UserError((Operator)this, 136, attribute.getName());
        }
        Attribute newAttribute = AttributeFactory.createAttribute(this.getParameterAsString(PARAMETER_ATTRIBUTE_NAME), valueType);
        exampleSet.getExampleTable().addAttribute(newAttribute);
        exampleSet.getAttributes().addRegular(newAttribute);
        double[] values = new double[attributes.size()];
        for (Example example : exampleSet) {
            int i = 0;
            for (Attribute attribute : attributes) {
                values[i] = example.getValue(attribute);
                ++i;
            }
            example.setValue(newAttribute, aggregationFunction.calculate(values));
        }
        if (!this.getParameterAsBoolean(PARAMETER_KEEP_ALL)) {
            for (Attribute attribute : attributes) {
                exampleSet.getAttributes().remove(attribute);
            }
        }
        return exampleSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeString(PARAMETER_ATTRIBUTE_NAME, "Name of the resulting attributes.", false));
        types.addAll(new AttributeSubsetSelector(this, this.getExampleSetInputPort()).getParameterTypes());
        ParameterTypeSingle type = new ParameterTypeCategory(PARAMETER_AGGREGATION_FUNCTION, "Function for aggregating the attribute values.", AbstractAggregationFunction.KNOWN_AGGREGATION_FUNCTION_NAMES, 6);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeBoolean(PARAMETER_KEEP_ALL, "Indicates if the all old attributes should be kept.", true);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeBoolean(PARAMETER_IGNORE_MISSINGS, "Indicates if missings should be ignored and aggregation should be based only on existing values or not. In the latter case the aggregated value will be missing in the presence of missing values.", true));
        return types;
    }
}

