/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.aggregation;

import com.rapidminer.datatable.SimpleDataTable;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.generator.AlgebraicOrGenerator;
import com.rapidminer.generator.FeatureGenerator;
import com.rapidminer.generator.MinMaxGenerator;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.features.aggregation.AggregationCrossover;
import com.rapidminer.operator.features.aggregation.AggregationIndividual;
import com.rapidminer.operator.features.aggregation.AggregationMutation;
import com.rapidminer.operator.features.aggregation.AggregationNonDominatedSortingSelection;
import com.rapidminer.operator.features.aggregation.AggregationPopulationPlotter;
import com.rapidminer.operator.features.aggregation.AggregationSelection;
import com.rapidminer.operator.features.aggregation.AggregationTournamentSelection;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetPassThroughRule;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.operator.ports.metadata.SubprocessTransformRule;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeFile;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.conditions.EqualTypeCondition;
import com.rapidminer.tools.RandomGenerator;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public class EvolutionaryFeatureAggregation
extends OperatorChain {
    public static final String PARAMETER_POPULATION_CRITERIA_DATA_FILE = "population_criteria_data_file";
    public static final String PARAMETER_AGGREGATION_FUNCTION = "aggregation_function";
    public static final String PARAMETER_POPULATION_SIZE = "population_size";
    public static final String PARAMETER_MAXIMUM_NUMBER_OF_GENERATIONS = "maximum_number_of_generations";
    public static final String PARAMETER_SELECTION_TYPE = "selection_type";
    public static final String PARAMETER_TOURNAMENT_FRACTION = "tournament_fraction";
    public static final String PARAMETER_CROSSOVER_TYPE = "crossover_type";
    public static final String PARAMETER_P_CROSSOVER = "p_crossover";
    private static final String[] SELECTION_TYPES = new String[]{"tournament", "non-dominated"};
    private static final int SELECTION_TOURNAMENT = 0;
    private static final int SELECTION_MO = 1;
    private static final String[] AGGREGATION_FUNCTIONS = new String[]{"maximum", "algebraic_or"};
    private static final int AGGREGATION_MAX = 0;
    private static final int AGGREGATION_ALGEBRAIC = 1;
    private Attribute[] allAttributes;
    private FeatureGenerator generator = new MinMaxGenerator(1);
    private int generation = 0;
    private int maxGeneration = 100;
    private final InputPort exampleSetInput = this.getInputPorts().createPort("example set in", ExampleSet.class);
    private final OutputPort innerExampleSetSource = (OutputPort)this.getSubprocess(0).getInnerSources().createPort("example set source");
    private final InputPort innerPerformanceSink = this.getSubprocess(0).getInnerSinks().createPort("performance vector sink", PerformanceVector.class);
    private final OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set out");
    private final OutputPort performanceOutput = (OutputPort)this.getOutputPorts().createPort("performance vector out");

    public EvolutionaryFeatureAggregation(OperatorDescription description) {
        super(description, "Performance Evaluation");
        this.getTransformer().addRule(new ExampleSetPassThroughRule(this.exampleSetInput, this.exampleSetOutput, SetRelation.SUBSET){

            @Override
            public ExampleSetMetaData modifyExampleSet(ExampleSetMetaData metaData) {
                for (AttributeMetaData amd : metaData.getAllAttributes()) {
                    if (!amd.isNumerical()) continue;
                    amd.setValueSetRelation(SetRelation.UNKNOWN);
                }
                return metaData;
            }
        });
        this.getTransformer().addRule(new ExampleSetPassThroughRule(this.exampleSetInput, this.innerExampleSetSource, SetRelation.SUBSET){

            @Override
            public ExampleSetMetaData modifyExampleSet(ExampleSetMetaData metaData) {
                for (AttributeMetaData amd : metaData.getAllAttributes()) {
                    if (!amd.isNumerical()) continue;
                    amd.setValueSetRelation(SetRelation.UNKNOWN);
                }
                return metaData;
            }
        });
        this.getTransformer().addRule(new SubprocessTransformRule(this.getSubprocess(0)));
        this.getTransformer().addPassThroughRule(this.innerPerformanceSink, this.performanceOutput);
    }

    @Override
    public void doWork() throws OperatorException {
        ExampleSet exampleSet = (ExampleSet)this.exampleSetInput.getData();
        int popSize = this.getParameterAsInt(PARAMETER_POPULATION_SIZE);
        this.generation = 0;
        this.maxGeneration = this.getParameterAsInt(PARAMETER_MAXIMUM_NUMBER_OF_GENERATIONS);
        int functionType = this.getParameterAsInt(PARAMETER_AGGREGATION_FUNCTION);
        switch (functionType) {
            case 0: {
                this.generator = new MinMaxGenerator(1);
                break;
            }
            case 1: {
                this.generator = new AlgebraicOrGenerator();
            }
        }
        RandomGenerator random = RandomGenerator.getRandomGenerator(this);
        this.allAttributes = new Attribute[exampleSet.getAttributes().size()];
        int index = 0;
        for (Attribute attribute : exampleSet.getAttributes()) {
            this.allAttributes[index++] = attribute;
        }
        AggregationPopulationPlotter plotter = new AggregationPopulationPlotter(exampleSet, this.allAttributes, this.generator);
        AggregationCrossover crossover = new AggregationCrossover(this.getParameterAsInt(PARAMETER_CROSSOVER_TYPE), this.getParameterAsDouble(PARAMETER_P_CROSSOVER), random);
        AggregationMutation mutation = new AggregationMutation(random);
        int selectionType = this.getParameterAsInt(PARAMETER_SELECTION_TYPE);
        AggregationSelection selection = null;
        switch (selectionType) {
            case 0: {
                selection = new AggregationTournamentSelection(popSize, this.getParameterAsDouble(PARAMETER_TOURNAMENT_FRACTION), random);
                break;
            }
            case 1: {
                selection = new AggregationNonDominatedSortingSelection(popSize);
            }
        }
        List<AggregationIndividual> population = this.createInitialPopulation(popSize, exampleSet.getAttributes().size(), random);
        while (!this.solutionGoodEnough()) {
            ++this.generation;
            crossover.crossover(population);
            mutation.mutate(population);
            this.evaluate(population, exampleSet);
            selection.performSelection(population);
            plotter.operate(population);
            this.inApplyLoop();
        }
        if (this.isParameterSet(PARAMETER_POPULATION_CRITERIA_DATA_FILE)) {
            File outFile = this.getParameterAsFile(PARAMETER_POPULATION_CRITERIA_DATA_FILE, true);
            SimpleDataTable finalStatistics = plotter.createDataTable(population);
            plotter.fillDataTable(finalStatistics, population);
            PrintWriter out = null;
            try {
                out = new PrintWriter(new FileWriter(outFile));
                finalStatistics.write(out);
            }
            catch (IOException e) {
                throw new UserError((Operator)this, (Throwable)e, 303, outFile, e.getMessage());
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
        this.evaluate(population, exampleSet);
        Iterator<AggregationIndividual> i = population.iterator();
        AggregationIndividual bestEver = null;
        PerformanceVector bestPerformance = null;
        while (i.hasNext()) {
            AggregationIndividual current = i.next();
            PerformanceVector currentPerf = current.getPerformance();
            if (bestPerformance != null && currentPerf.compareTo(bestPerformance) <= 0) continue;
            bestPerformance = currentPerf;
            bestEver = current;
        }
        this.exampleSetOutput.deliver(bestEver.createExampleSet(exampleSet, this.allAttributes, this.generator));
        this.performanceOutput.deliver(bestPerformance);
    }

    private List<AggregationIndividual> createInitialPopulation(int popSize, int individualSize, Random random) {
        ArrayList<AggregationIndividual> population = new ArrayList<AggregationIndividual>();
        for (int i = 0; i < popSize; ++i) {
            int[] individual = new int[individualSize];
            for (int a = 0; a < individual.length; ++a) {
                individual[a] = random.nextBoolean() ? 0 : 1;
            }
            population.add(new AggregationIndividual(individual));
        }
        return population;
    }

    private boolean solutionGoodEnough() {
        return this.generation > this.maxGeneration;
    }

    public void evaluate(List population, ExampleSet originalExampleSet) throws OperatorException {
        Iterator i = population.iterator();
        while (i.hasNext()) {
            AggregationIndividual individual = (AggregationIndividual)i.next();
            if (individual.getPerformance() != null) continue;
            ExampleSet exampleSet = individual.createExampleSet(originalExampleSet, this.allAttributes, this.generator);
            if (exampleSet.getAttributes().size() == 0) {
                i.remove();
                continue;
            }
            this.innerExampleSetSource.deliver(exampleSet);
            this.getSubprocess(0).execute();
            PerformanceVector performanceVector = (PerformanceVector)this.innerPerformanceSink.getData();
            individual.setPerformance(performanceVector);
        }
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeCategory(PARAMETER_AGGREGATION_FUNCTION, "The aggregation function which is used for feature aggregations.", AGGREGATION_FUNCTIONS, 0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_POPULATION_SIZE, "Number of individuals per generation.", 1, Integer.MAX_VALUE, 10);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_MAXIMUM_NUMBER_OF_GENERATIONS, "Number of generations after which to terminate the algorithm.", 1, Integer.MAX_VALUE, 100);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeCategory(PARAMETER_SELECTION_TYPE, "The type of selection.", SELECTION_TYPES, 0);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_TOURNAMENT_FRACTION, "The fraction of the population which will participate in each tournament.", 0.0, 1.0, 0.2);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_SELECTION_TYPE, SELECTION_TYPES, false, 0));
        types.add(type);
        types.add(new ParameterTypeCategory(PARAMETER_CROSSOVER_TYPE, "The type of crossover.", AggregationCrossover.CROSSOVER_TYPES, 1));
        types.add(new ParameterTypeDouble(PARAMETER_P_CROSSOVER, "Probability for an individual to be selected for crossover.", 0.0, 1.0, 0.9));
        types.add(new ParameterTypeFile(PARAMETER_POPULATION_CRITERIA_DATA_FILE, "The path to the file in which the criteria data of the final population should be saved.", "crit", true));
        types.addAll(RandomGenerator.getRandomGeneratorParameters(this));
        return types;
    }
}

