/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.aggregation;

import com.rapidminer.ObjectVisualizer;
import com.rapidminer.datatable.SimpleDataTable;
import com.rapidminer.datatable.SimpleDataTableRow;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.generator.FeatureGenerator;
import com.rapidminer.generator.GenerationException;
import com.rapidminer.gui.plotter.SimplePlotterDialog;
import com.rapidminer.gui.processeditor.results.ResultDisplayTools;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.operator.features.aggregation.AggregationIndividual;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.tools.Tools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class AggregationPopulationPlotter
implements ObjectVisualizer {
    private ExampleSet originalExampleSet;
    private Attribute[] allAttributes;
    private FeatureGenerator generator;
    private SimplePlotterDialog plotter = null;
    private SimpleDataTable criteriaDataTable = null;
    private List<AggregationIndividual> lastPopulation;

    public AggregationPopulationPlotter(ExampleSet originalExampleSet, Attribute[] allAttributes, FeatureGenerator generator) {
        this.originalExampleSet = originalExampleSet;
        this.allAttributes = allAttributes;
        this.generator = generator;
    }

    public void operate(List<AggregationIndividual> pop) {
        if (pop.size() == 0) {
            return;
        }
        if (this.criteriaDataTable == null) {
            this.criteriaDataTable = this.createDataTable(pop);
        }
        int numberOfCriteria = this.fillDataTable(this.criteriaDataTable, pop);
        if (this.plotter == null) {
            this.plotter = new SimplePlotterDialog(this.criteriaDataTable, false);
            if (numberOfCriteria == 1) {
                this.plotter.setXAxis(0);
                this.plotter.plotColumn(0, true);
            } else if (numberOfCriteria == 2) {
                this.plotter.setXAxis(0);
                this.plotter.plotColumn(1, true);
            } else if (numberOfCriteria > 2) {
                this.plotter.setXAxis(0);
                this.plotter.setYAxis(1);
                this.plotter.plotColumn(2, true);
            }
            this.plotter.setPointType(2);
            this.plotter.setVisible(true);
            this.plotter.addObjectVisualizer(this);
        }
        this.lastPopulation = pop;
    }

    public SimpleDataTable createDataTable(List<AggregationIndividual> pop) {
        PerformanceVector prototype = pop.get(0).getPerformance();
        SimpleDataTable dataTable = new SimpleDataTable("Population", prototype.getCriteriaNames());
        return dataTable;
    }

    public int fillDataTable(SimpleDataTable dataTable, List<AggregationIndividual> pop) {
        dataTable.clear();
        int numberOfCriteria = 0;
        for (int i = 0; i < pop.size(); ++i) {
            StringBuffer id = new StringBuffer(i + " (");
            PerformanceVector current = pop.get(i).getPerformance();
            numberOfCriteria = Math.max(numberOfCriteria, current.getSize());
            double[] data = new double[current.getSize()];
            for (int d = 0; d < data.length; ++d) {
                data[d] = current.getCriterion(d).getFitness();
                if (d != 0) {
                    id.append(", ");
                }
                id.append(Tools.formatNumber(data[d]));
            }
            id.append(")");
            dataTable.add(new SimpleDataTableRow(data, id.toString()));
        }
        return numberOfCriteria;
    }

    @Override
    public boolean isCapableToVisualize(Object id) {
        int index = 0;
        if (id instanceof String) {
            String idString = (String)id;
            index = Integer.parseInt(idString.substring(0, idString.indexOf("(")).trim());
        } else {
            index = ((Double)id).intValue();
        }
        return index >= 0 && index < this.lastPopulation.size();
    }

    @Override
    public String getTitle(Object id) {
        return id instanceof String ? (String)id : ((Double)id).toString();
    }

    @Override
    public String getDetailData(Object id, String fieldName) {
        return null;
    }

    @Override
    public String[] getFieldNames(Object id) {
        return new String[0];
    }

    @Override
    public void stopVisualization(Object id) {
    }

    @Override
    public void startVisualization(Object id) {
        int index = 0;
        if (id instanceof String) {
            String idString = (String)id;
            index = Integer.parseInt(idString.substring(0, idString.indexOf("(")).trim());
        } else {
            index = ((Double)id).intValue();
        }
        AggregationIndividual individual = this.lastPopulation.get(index);
        ExampleSet es = null;
        try {
            es = individual.createExampleSet(this.originalExampleSet, this.allAttributes, this.generator);
        }
        catch (GenerationException e) {
            throw new RuntimeException("Cannot visualize individual '" + index + "': " + e.getMessage());
        }
        JPanel visualizationComponent = ResultDisplayTools.createVisualizationComponent(es, null, es.getName());
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(2);
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)new ExtendedJScrollPane(visualizationComponent), "Center");
        frame.setSize(600, 400);
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }
}

