/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.aggregation;

import com.rapidminer.operator.features.aggregation.AggregationIndividual;
import com.rapidminer.operator.features.aggregation.AggregationSelection;
import com.rapidminer.operator.performance.PerformanceVector;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class AggregationNonDominatedSortingSelection
implements AggregationSelection {
    private int popSize;

    public AggregationNonDominatedSortingSelection(int popSize) {
        this.popSize = popSize;
    }

    @Override
    public void performSelection(List<AggregationIndividual> population) {
        int index;
        ArrayList<List<AggregationIndividual>> ranks = new ArrayList<List<AggregationIndividual>>();
        while (population.size() > 0) {
            List<AggregationIndividual> rank = this.getNextRank(population);
            ranks.add(rank);
            Iterator<AggregationIndividual> i = rank.iterator();
            while (i.hasNext()) {
                population.remove(i.next());
            }
        }
        population.clear();
        for (index = 0; index < ranks.size() && population.size() + ((List)ranks.get(index)).size() <= this.popSize; ++index) {
            population.addAll((Collection)ranks.get(index));
        }
        if (population.size() < this.popSize) {
            List rank = (List)ranks.get(index);
            this.sortByCrowdingDistance(rank);
            while (population.size() < this.popSize) {
                population.add((AggregationIndividual)rank.remove(0));
            }
        }
    }

    private void sortByCrowdingDistance(List<AggregationIndividual> rank) {
        Iterator<AggregationIndividual> f = rank.iterator();
        int numberOfCriteria = 0;
        while (f.hasNext()) {
            AggregationIndividual current = f.next();
            current.setCrowdingDistance(0.0);
            numberOfCriteria = Math.max(numberOfCriteria, current.getPerformance().getSize());
        }
        for (int m = 0; m < numberOfCriteria; ++m) {
            CriteriaComparator comparator = new CriteriaComparator(m);
            Collections.sort(rank, comparator);
            rank.get(0).setCrowdingDistance(Double.POSITIVE_INFINITY);
            rank.get(rank.size() - 1).setCrowdingDistance(Double.POSITIVE_INFINITY);
            for (int i = 1; i < rank.size() - 1; ++i) {
                AggregationIndividual current = rank.get(i);
                double currentCrowdingDistance = current.getCrowdingDistance();
                AggregationIndividual afterI = rank.get(i + 1);
                AggregationIndividual beforeI = rank.get(i - 1);
                double afterPerformance = afterI.getPerformance().getCriterion(m).getFitness();
                double beforePerformance = beforeI.getPerformance().getCriterion(m).getFitness();
                current.setCrowdingDistance(currentCrowdingDistance + Math.abs(afterPerformance - beforePerformance));
            }
        }
        Collections.sort(rank, new CrowdingComparator());
    }

    private List<AggregationIndividual> getNextRank(List<AggregationIndividual> population) {
        ArrayList<AggregationIndividual> rank = new ArrayList<AggregationIndividual>();
        for (int i = 0; i < population.size(); ++i) {
            AggregationIndividual current = population.get(i);
            rank.add(current);
            boolean delete = false;
            for (int j = rank.size() - 2; j >= 0; --j) {
                AggregationIndividual ranked = (AggregationIndividual)rank.get(j);
                if (AggregationNonDominatedSortingSelection.isDominated(ranked, current)) {
                    rank.remove(ranked);
                }
                if (!AggregationNonDominatedSortingSelection.isDominated(current, ranked)) continue;
                delete = true;
            }
            if (!delete) continue;
            rank.remove(current);
        }
        return rank;
    }

    public static boolean isDominated(AggregationIndividual i1, AggregationIndividual i2) {
        PerformanceVector pv1 = i1.getPerformance();
        PerformanceVector pv2 = i2.getPerformance();
        double[][] performances = new double[pv1.getSize()][2];
        for (int p = 0; p < performances.length; ++p) {
            performances[p][0] = pv1.getCriterion(p).getFitness();
            performances[p][1] = pv2.getCriterion(p).getFitness();
        }
        boolean dominated = true;
        for (int p = 0; p < performances.length; ++p) {
            dominated &= performances[p][1] >= performances[p][0];
        }
        boolean oneActuallyBetter = false;
        for (int p = 0; p < performances.length; ++p) {
            oneActuallyBetter |= performances[p][1] > performances[p][0];
        }
        return dominated &= oneActuallyBetter;
    }

    private static class CrowdingComparator
    implements Comparator<AggregationIndividual>,
    Serializable {
        private static final long serialVersionUID = 4712425942757940295L;

        private CrowdingComparator() {
        }

        @Override
        public int compare(AggregationIndividual i1, AggregationIndividual i2) {
            double cd1 = i1.getCrowdingDistance();
            double cd2 = i2.getCrowdingDistance();
            return -1 * Double.compare(cd1, cd2);
        }
    }

    private static class CriteriaComparator
    implements Comparator<AggregationIndividual>,
    Serializable {
        private static final long serialVersionUID = 4188525398056332510L;
        private int m;

        public CriteriaComparator(int m) {
            this.m = m;
        }

        @Override
        public int compare(AggregationIndividual i1, AggregationIndividual i2) {
            PerformanceVector pv1 = i1.getPerformance();
            PerformanceVector pv2 = i2.getPerformance();
            return -1 * Double.compare(pv1.getCriterion(this.m).getFitness(), pv2.getCriterion(this.m).getFitness());
        }
    }
}

