/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.aggregation;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.AttributeWeightedExampleSet;
import com.rapidminer.generator.FeatureGenerator;
import com.rapidminer.generator.GenerationException;
import com.rapidminer.operator.performance.PerformanceVector;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class AggregationIndividual {
    private final int[] individual;
    private PerformanceVector fitness = null;
    private double crowdingDistance;

    public AggregationIndividual(int[] individual) {
        this.individual = individual;
    }

    public double getCrowdingDistance() {
        return this.crowdingDistance;
    }

    public void setCrowdingDistance(double crowdingDistance) {
        this.crowdingDistance = crowdingDistance;
    }

    public int[] getIndividual() {
        return this.individual;
    }

    public void setPerformance(PerformanceVector fitness) {
        this.fitness = fitness;
    }

    public PerformanceVector getPerformance() {
        return this.fitness;
    }

    public ExampleSet createExampleSet(ExampleSet originalExampleSet, Attribute[] allAttributes, FeatureGenerator generator) throws GenerationException {
        List<String> mergeList;
        AttributeWeightedExampleSet es = new AttributeWeightedExampleSet(originalExampleSet, null);
        HashMap<Integer, LinkedList<String>> mergeMap = new HashMap<Integer, LinkedList<String>>();
        for (int i = 0; i < this.individual.length; ++i) {
            if (this.individual[i] == 0) {
                es.setWeight(allAttributes[i], 1.0);
                continue;
            }
            es.setWeight(allAttributes[i], 0.0);
            if (this.individual[i] <= 0) continue;
            mergeList = (List)mergeMap.get(this.individual[i]);
            if (mergeList != null) {
                mergeList.add(allAttributes[i].getName());
                continue;
            }
            mergeList = new LinkedList<String>();
            mergeList.add(allAttributes[i].getName());
            mergeMap.put(this.individual[i], (LinkedList<String>)mergeList);
        }
        Iterator i = mergeMap.keySet().iterator();
        while (i.hasNext()) {
            mergeList = (LinkedList<String>)mergeMap.get(i.next());
            if (mergeList.size() == 1) {
                es.setWeight(es.getAttributes().getRegular((String)mergeList.get(0)), 1.0);
                continue;
            }
            if (mergeList.size() <= 1) continue;
            this.addNewMergedAttribute(es, mergeList, generator);
        }
        AttributeWeightedExampleSet result = es.createCleanClone();
        return result;
    }

    private void addNewMergedAttribute(AttributeWeightedExampleSet es, List<String> mergeList, FeatureGenerator generator) throws GenerationException {
        Attribute mergeAttribute = null;
        Iterator<String> i = mergeList.iterator();
        while (i.hasNext()) {
            Attribute currentAttribute = es.getAttributes().getRegular(i.next());
            if (mergeAttribute == null) {
                mergeAttribute = currentAttribute;
                continue;
            }
            generator = generator.newInstance();
            Attribute[] args = new Attribute[]{mergeAttribute, currentAttribute};
            generator.setArguments(args);
            LinkedList<FeatureGenerator> generatorList = new LinkedList<FeatureGenerator>();
            generatorList.add(generator);
            List<Attribute> newAttributes = FeatureGenerator.generateAll(es.getExampleTable(), generatorList);
            mergeAttribute = newAttributes.get(0);
        }
        es.getAttributes().addRegular(mergeAttribute);
    }
}

