/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.aggregation;

import com.rapidminer.operator.features.aggregation.AggregationIndividual;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class AggregationCrossover {
    public static final String[] CROSSOVER_TYPES = new String[]{"one_point", "uniform"};
    public static final int CROSSOVER_ONE_POINT = 0;
    public static final int CROSSOVER_UNIFORM = 1;
    private int crossoverType = 1;
    private double crossoverProb = 0.9;
    private Random random;

    public AggregationCrossover(int type, double probability, Random random) {
        this.crossoverType = type;
        this.crossoverProb = probability;
        this.random = random;
    }

    private boolean isValid(int[] individual) {
        for (int i = 0; i < individual.length; ++i) {
            if (individual[i] < 0) continue;
            return true;
        }
        return false;
    }

    public void crossover(List<AggregationIndividual> population) {
        ArrayList<AggregationIndividual> children = new ArrayList<AggregationIndividual>();
        for (int i = 0; i < population.size(); ++i) {
            if (!(this.random.nextDouble() < this.crossoverProb)) continue;
            int[] parent1 = population.get(this.random.nextInt(population.size())).getIndividual();
            int[] parent2 = population.get(this.random.nextInt(population.size())).getIndividual();
            int[] child1 = new int[parent1.length];
            for (int j = 0; j < child1.length; ++j) {
                child1[j] = parent1[j];
            }
            int[] child2 = new int[parent2.length];
            for (int j = 0; j < child2.length; ++j) {
                child2[j] = parent2[j];
            }
            this.crossover(child1, child2);
            if (this.isValid(child1)) {
                children.add(new AggregationIndividual(child1));
            }
            if (!this.isValid(child2)) continue;
            children.add(new AggregationIndividual(child2));
        }
        population.addAll(children);
    }

    private void crossover(int[] individual1, int[] individual2) {
        switch (this.crossoverType) {
            case 0: {
                int n;
                for (int i = n = 1 + this.random.nextInt(individual1.length - 1); i < individual1.length; ++i) {
                    int dummy = individual1[i];
                    individual1[i] = individual2[i];
                    individual2[i] = dummy;
                }
                break;
            }
            case 1: {
                for (int i = 0; i < individual1.length; ++i) {
                    if (!this.random.nextBoolean()) continue;
                    int dummy = individual1[i];
                    individual1[i] = individual2[i];
                    individual2[i] = dummy;
                }
                break;
            }
        }
    }
}

