/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.features.FeatureOperator;
import com.rapidminer.operator.features.Individual;
import com.rapidminer.operator.features.Population;
import com.rapidminer.operator.features.PopulationEvaluator;
import com.rapidminer.operator.performance.PerformanceVector;

public class SimplePopulationEvaluator
implements PopulationEvaluator {
    private ExampleSet originalSet;
    private FeatureOperator operator;

    public SimplePopulationEvaluator(FeatureOperator operator, ExampleSet originalSet) {
        this.originalSet = originalSet;
        this.operator = operator;
    }

    private final void evaluate(Individual individual) throws OperatorException {
        if (individual.getPerformance() == null) {
            double[] weights = individual.getWeights();
            ExampleSet clone = FeatureOperator.createCleanClone(this.originalSet, weights);
            PerformanceVector performanceVector = this.operator.executeEvaluationProcess(clone);
            individual.setPerformance(performanceVector);
        }
    }

    @Override
    public void evaluate(Population population) throws OperatorException {
        for (int i = 0; i < population.getNumberOfIndividuals(); ++i) {
            this.evaluate(population.get(i));
            population.updateEvaluation();
        }
    }
}

