/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features;

import com.rapidminer.ObjectVisualizer;
import com.rapidminer.datatable.SimpleDataTable;
import com.rapidminer.datatable.SimpleDataTableRow;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.gui.plotter.SimplePlotterDialog;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.viewer.DataTableViewer;
import com.rapidminer.operator.features.Population;
import com.rapidminer.operator.features.PopulationOperator;
import com.rapidminer.operator.features.selection.NonDominatedSortingSelection;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.tools.Tools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFrame;

public class PopulationPlotter
implements PopulationOperator,
ObjectVisualizer {
    private int plotGenerations = 1;
    private SimplePlotterDialog plotter = null;
    private SimpleDataTable criteriaDataTable = null;
    private boolean setDrawRange = false;
    private boolean drawDominated = true;
    private Map<String, double[]> lastPopulation = new HashMap<String, double[]>();
    private ExampleSet exampleSet;

    public PopulationPlotter(ExampleSet exampleSet) {
        this(exampleSet, 1, false, true);
    }

    public PopulationPlotter(ExampleSet exampleSet, int plotGenerations, boolean setDrawRange, boolean drawDominated) {
        this.exampleSet = exampleSet;
        this.plotGenerations = plotGenerations;
        this.setDrawRange = setDrawRange;
        this.drawDominated = drawDominated;
    }

    @Override
    public boolean performOperation(int generation) {
        return generation % this.plotGenerations == 0;
    }

    @Override
    public void operate(Population pop) {
        if (pop.getNumberOfIndividuals() == 0) {
            return;
        }
        if (pop.getGeneration() % this.plotGenerations != 0) {
            return;
        }
        if (this.criteriaDataTable == null) {
            this.criteriaDataTable = PopulationPlotter.createDataTable(pop);
        }
        int numberOfCriteria = PopulationPlotter.fillDataTable(this.criteriaDataTable, this.lastPopulation, pop, this.drawDominated);
        if (this.plotter == null) {
            this.plotter = new SimplePlotterDialog(this.criteriaDataTable, false);
            if (numberOfCriteria == 1) {
                this.plotter.setXAxis(0);
                this.plotter.plotColumn(0, true);
            } else if (numberOfCriteria == 2) {
                this.plotter.setXAxis(0);
                this.plotter.plotColumn(1, true);
            } else if (numberOfCriteria > 2) {
                this.plotter.setXAxis(0);
                this.plotter.setYAxis(1);
                this.plotter.plotColumn(2, true);
            }
            this.plotter.setPointType(2);
            this.plotter.setVisible(true);
            this.plotter.addObjectVisualizer(this);
        }
        if (this.setDrawRange) {
            this.plotter.setDrawRange(0.0, 1.0, 0.0, 1.0);
        }
        this.plotter.setKey("Generation " + pop.getGeneration());
    }

    public static SimpleDataTable createDataTable(Population pop) {
        PerformanceVector prototype = pop.get(0).getPerformance();
        SimpleDataTable dataTable = new SimpleDataTable("Population", prototype.getCriteriaNames());
        return dataTable;
    }

    public static int fillDataTable(SimpleDataTable dataTable, Map<String, double[]> lastPopulation, Population pop, boolean drawDominated) {
        lastPopulation.clear();
        dataTable.clear();
        int numberOfCriteria = 0;
        for (int i = 0; i < pop.getNumberOfIndividuals(); ++i) {
            boolean dominated = false;
            if (!drawDominated) {
                for (int j = 0; j < pop.getNumberOfIndividuals(); ++j) {
                    if (i == j || !NonDominatedSortingSelection.isDominated(pop.get(i), pop.get(j))) continue;
                    dominated = true;
                    break;
                }
            }
            if (!drawDominated && dominated) continue;
            StringBuffer id = new StringBuffer(i + " (");
            PerformanceVector current = pop.get(i).getPerformance();
            numberOfCriteria = Math.max(numberOfCriteria, current.getSize());
            double[] data = new double[current.getSize()];
            for (int d = 0; d < data.length; ++d) {
                data[d] = current.getCriterion(d).getFitness();
                if (d != 0) {
                    id.append(", ");
                }
                id.append(Tools.formatNumber(data[d]));
            }
            id.append(")");
            dataTable.add(new SimpleDataTableRow(data, id.toString()));
            double[] weights = pop.get(i).getWeights();
            double[] clone = new double[weights.length];
            System.arraycopy(weights, 0, clone, 0, weights.length);
            lastPopulation.put(id.toString(), clone);
        }
        return numberOfCriteria;
    }

    @Override
    public boolean isCapableToVisualize(Object id) {
        return this.lastPopulation.get(id) != null;
    }

    @Override
    public String getTitle(Object id) {
        return id instanceof String ? (String)id : ((Double)id).toString();
    }

    @Override
    public String getDetailData(Object id, String fieldName) {
        return null;
    }

    @Override
    public String[] getFieldNames(Object id) {
        return new String[0];
    }

    @Override
    public void stopVisualization(Object id) {
    }

    @Override
    public void startVisualization(Object id) {
        double[] weights = this.lastPopulation.get(id);
        SimpleDataTable dataTable = new SimpleDataTable("Attribute Weights", new String[]{"Attribute", "Weight"});
        int a = 0;
        for (Attribute attribute : this.exampleSet.getAttributes()) {
            dataTable.add(new SimpleDataTableRow(new double[]{dataTable.mapString(0, attribute.getName()), weights[a++]}));
        }
        DataTableViewer visualizationComponent = new DataTableViewer(dataTable);
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(2);
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)new ExtendedJScrollPane(visualizationComponent), "Center");
        frame.setSize(600, 400);
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }
}

