/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features;

import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.AttributeWeightedExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.ExampleSetPassThroughRule;
import com.rapidminer.operator.ports.metadata.SetRelation;

public class AttributeWeightsApplier
extends Operator {
    private final InputPort exampleSetInput = this.getInputPorts().createPort("example set", ExampleSet.class);
    private final InputPort weightsInput = this.getInputPorts().createPort("weights", AttributeWeights.class);
    private final OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set");

    public AttributeWeightsApplier(OperatorDescription description) {
        super(description);
        this.getTransformer().addRule(new ExampleSetPassThroughRule(this.exampleSetInput, this.exampleSetOutput, SetRelation.SUBSET));
    }

    @Override
    public void doWork() throws OperatorException {
        AttributeWeights weights = (AttributeWeights)this.weightsInput.getData();
        ExampleSet exampleSet = (ExampleSet)this.exampleSetInput.getData();
        AttributeWeightedExampleSet weightedSet = new AttributeWeightedExampleSet(exampleSet, weights);
        AttributeWeightedExampleSet result = weightedSet.createCleanClone();
        this.exampleSetOutput.deliver(result);
    }
}

