/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.condition;

import com.rapidminer.operator.DefaultIODescription;
import com.rapidminer.operator.IllegalInputException;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.WrongNumberOfInnerOperatorsException;
import com.rapidminer.operator.condition.InnerOperatorCondition;

public class SpecificInnerOperatorCondition
implements InnerOperatorCondition {
    private final String name;
    private final int index;
    private final Class[] willGet;
    private final Class[] mustDeliver;

    public SpecificInnerOperatorCondition(String name, int index, Class[] willGet, Class[] mustDeliver) {
        this.name = name;
        this.index = index;
        this.willGet = willGet;
        this.mustDeliver = mustDeliver;
    }

    @Override
    public Class[] checkIO(OperatorChain chain, Class[] input) throws IllegalInputException, WrongNumberOfInnerOperatorsException {
        if (this.index < 0 || this.index >= chain.getNumberOfOperators()) {
            throw new WrongNumberOfInnerOperatorsException(chain, chain.getMinNumberOfInnerOperators(), chain.getMaxNumberOfInnerOperators(), this.index);
        }
        Operator operator = chain.getOperator(this.index);
        if (this.index == 0) {
            for (Class c : this.willGet) {
                if (DefaultIODescription.containsClass(c, input)) continue;
                throw new IllegalInputException(operator, c);
            }
        }
        Class<?>[] output = operator.checkIO(this.willGet);
        for (int i = 0; i < this.mustDeliver.length; ++i) {
            if (DefaultIODescription.containsClass(this.mustDeliver[i], output)) continue;
            throw new IllegalInputException(chain, operator, this.mustDeliver[i]);
        }
        return this.mustDeliver;
    }

    @Override
    public String toHTML() {
        int i;
        StringBuffer result = new StringBuffer("Operator " + (this.index + 1) + " (" + this.name + ") must be able to handle [");
        for (i = 0; i < this.willGet.length; ++i) {
            if (i != 0) {
                result.append(", ");
            }
            result.append(this.willGet[i].getSimpleName());
        }
        result.append("]");
        if (this.mustDeliver != null && this.mustDeliver.length > 0) {
            result.append(" and must deliver [");
            for (i = 0; i < this.mustDeliver.length; ++i) {
                if (i != 0) {
                    result.append(", ");
                }
                result.append(this.mustDeliver[i].getSimpleName());
            }
            result.append("].");
        } else {
            result.append(".");
        }
        return result.toString();
    }
}

