/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.condition;

import com.rapidminer.operator.DefaultIODescription;
import com.rapidminer.operator.IllegalInputException;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.WrongNumberOfInnerOperatorsException;
import com.rapidminer.operator.condition.InnerOperatorCondition;

public class LastInnerOperatorCondition
implements InnerOperatorCondition {
    private final Class[] mustDeliver;
    private final Class[] willGet;
    private boolean allowEmptyChains = false;

    public LastInnerOperatorCondition(Class[] mustDeliver) {
        this(null, mustDeliver);
    }

    public LastInnerOperatorCondition(Class[] willGet, Class[] mustDeliver) {
        this(willGet, mustDeliver, false);
    }

    public LastInnerOperatorCondition(Class[] willGet, Class[] mustDeliver, boolean allowEmptyChains) {
        this.willGet = willGet;
        this.mustDeliver = mustDeliver;
        this.allowEmptyChains = allowEmptyChains;
    }

    @Override
    public Class[] checkIO(OperatorChain chain, Class[] input) throws IllegalInputException, WrongNumberOfInnerOperatorsException {
        int i;
        if (!this.allowEmptyChains && chain.getNumberOfOperators() == 0) {
            throw new WrongNumberOfInnerOperatorsException(chain, chain.getMinNumberOfInnerOperators(), chain.getMaxNumberOfInnerOperators(), 0);
        }
        Class[] output = input;
        if (this.willGet != null) {
            output = new Class[input.length + this.willGet.length];
            System.arraycopy(input, 0, output, 0, input.length);
            System.arraycopy(this.willGet, 0, output, input.length, this.willGet.length);
        }
        for (i = 0; i < chain.getNumberOfOperators(); ++i) {
            Operator operator = chain.getOperator(i);
            if (!operator.isEnabled()) continue;
            output = operator.checkIO(output);
        }
        for (i = 0; i < this.mustDeliver.length; ++i) {
            if (DefaultIODescription.containsClass(this.mustDeliver[i], output)) continue;
            throw new IllegalInputException(chain, chain.getOperator(chain.getNumberOfOperators() - 1), this.mustDeliver[i]);
        }
        return output;
    }

    @Override
    public String toHTML() {
        int i;
        StringBuffer result = new StringBuffer("The inner operators ");
        if (this.willGet != null) {
            result.append("must be able to handle [");
            for (i = 0; i < this.willGet.length; ++i) {
                if (i != 0) {
                    result.append(", ");
                }
                result.append(this.willGet[i].getSimpleName());
            }
            result.append("]");
            if (this.mustDeliver != null) {
                result.append(" and ");
            } else {
                result.append(".");
            }
        }
        if (this.mustDeliver != null) {
            result.append("must deliver [");
            for (i = 0; i < this.mustDeliver.length; ++i) {
                if (i != 0) {
                    result.append(", ");
                }
                result.append(this.mustDeliver[i].getSimpleName());
            }
            result.append("].");
        }
        return result.toString();
    }
}

