/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.condition;

import com.rapidminer.operator.IllegalInputException;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.WrongNumberOfInnerOperatorsException;
import com.rapidminer.operator.condition.InnerOperatorCondition;

public class FirstInnerOperatorCondition
implements InnerOperatorCondition {
    private Class[] willGet;
    private boolean allowEmptyChains = false;

    public FirstInnerOperatorCondition(Class[] willGet) {
        this(willGet, false);
    }

    public FirstInnerOperatorCondition(Class[] willGet, boolean allowEmptyChains) {
        this.willGet = willGet;
        this.allowEmptyChains = allowEmptyChains;
    }

    @Override
    public Class[] checkIO(OperatorChain chain, Class[] input) throws IllegalInputException, WrongNumberOfInnerOperatorsException {
        if (!this.allowEmptyChains && chain.getNumberOfOperators() == 0) {
            throw new WrongNumberOfInnerOperatorsException(chain, chain.getMinNumberOfInnerOperators(), chain.getMaxNumberOfInnerOperators(), 0);
        }
        Class[] output = input;
        if (this.willGet != null) {
            output = new Class[input.length + this.willGet.length];
            System.arraycopy(input, 0, output, 0, input.length);
            System.arraycopy(this.willGet, 0, output, input.length, this.willGet.length);
        }
        for (int i = 0; i < chain.getNumberOfOperators(); ++i) {
            Operator operator = chain.getOperator(i);
            if (!operator.isEnabled()) continue;
            output = operator.checkIO(output);
        }
        return output;
    }

    @Override
    public String toHTML() {
        StringBuffer result = new StringBuffer("The inner operators ");
        if (this.willGet != null) {
            result.append("must be able to handle [");
            for (int i = 0; i < this.willGet.length; ++i) {
                if (i != 0) {
                    result.append(", ");
                }
                result.append(this.willGet[i].getSimpleName());
            }
            result.append("].");
        }
        return result.toString();
    }
}

