/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.condition;

import com.rapidminer.operator.DefaultIODescription;
import com.rapidminer.operator.IllegalInputException;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.WrongNumberOfInnerOperatorsException;
import com.rapidminer.operator.condition.InnerOperatorCondition;

public class AllInnerOperatorCondition
implements InnerOperatorCondition {
    private final Class[] willGet;
    private final Class[] mustDeliver;

    public AllInnerOperatorCondition(Class[] willGet, Class[] mustDeliver) {
        this.willGet = willGet;
        this.mustDeliver = mustDeliver;
    }

    @Override
    public Class[] checkIO(OperatorChain chain, Class[] input) throws IllegalInputException, WrongNumberOfInnerOperatorsException {
        if (chain.getNumberOfOperators() == 0) {
            throw new WrongNumberOfInnerOperatorsException(chain, chain.getMinNumberOfInnerOperators(), chain.getMaxNumberOfInnerOperators(), 0);
        }
        Class[] innerOutput = input;
        for (int i = 0; i < chain.getNumberOfOperators(); ++i) {
            Operator operator = chain.getOperator(i);
            innerOutput = operator.checkIO(this.willGet);
            for (int j = 0; j < this.mustDeliver.length; ++j) {
                if (DefaultIODescription.containsClass(this.mustDeliver[j], innerOutput)) continue;
                throw new IllegalInputException(chain, operator, this.mustDeliver[j]);
            }
        }
        return innerOutput;
    }

    @Override
    public String toHTML() {
        int i;
        StringBuffer result = new StringBuffer("Each inner operator must be able to handle [");
        for (i = 0; i < this.willGet.length; ++i) {
            if (i != 0) {
                result.append(", ");
            }
            result.append(this.willGet[i].getSimpleName());
        }
        result.append("] and must deliver [");
        for (i = 0; i < this.mustDeliver.length; ++i) {
            if (i != 0) {
                result.append(", ");
            }
            result.append(this.mustDeliver[i].getSimpleName());
        }
        result.append("].");
        return result.toString();
    }
}

