/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.collections;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.IOObjectCollection;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.CollectionMetaData;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaData;

public class UnfoldOperator
extends Operator {
    private final InputPort collectionInput = this.getInputPorts().createPort("collection", new CollectionMetaData());
    private final OutputPort flatOutput = (OutputPort)this.getOutputPorts().createPort("flat");

    public UnfoldOperator(OperatorDescription description) {
        super(description);
        this.getTransformer().addRule(new MDTransformationRule(){

            @Override
            public void transformMD() {
                MetaData md = UnfoldOperator.this.collectionInput.getMetaData();
                if (md != null && md instanceof CollectionMetaData) {
                    UnfoldOperator.this.flatOutput.deliverMD(new CollectionMetaData(((CollectionMetaData)md).getElementMetaDataRecursive()));
                } else {
                    UnfoldOperator.this.flatOutput.deliverMD(null);
                }
            }
        });
    }

    @Override
    public void doWork() throws OperatorException {
        IOObjectCollection collection = (IOObjectCollection)this.collectionInput.getData();
        this.flatOutput.deliver(new IOObjectCollection<IOObject>(collection.getObjectsRecursive()));
    }
}

