/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.collections;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.IOObjectCollection;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.CollectionMetaData;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeInt;
import java.util.List;

public class SelectionOperator
extends Operator {
    public static final String PARAMETER_INDEX = "index";
    public static final String PARAMETER_UNFOLD = "unfold";
    private final InputPort collectionInput = this.getInputPorts().createPort("collection", new CollectionMetaData(new MetaData()));
    private final OutputPort selectedOutput = (OutputPort)this.getOutputPorts().createPort("selected");

    public SelectionOperator(OperatorDescription description) {
        super(description);
        this.getTransformer().addRule(new MDTransformationRule(){

            @Override
            public void transformMD() {
                MetaData md = SelectionOperator.this.collectionInput.getMetaData();
                if (md instanceof CollectionMetaData) {
                    if (SelectionOperator.this.getParameterAsBoolean(SelectionOperator.PARAMETER_UNFOLD)) {
                        SelectionOperator.this.selectedOutput.deliverMD(((CollectionMetaData)md).getElementMetaDataRecursive());
                    } else {
                        SelectionOperator.this.selectedOutput.deliverMD(((CollectionMetaData)md).getElementMetaData());
                    }
                } else {
                    SelectionOperator.this.selectedOutput.deliverMD(null);
                }
            }
        });
    }

    @Override
    public void doWork() throws OperatorException {
        IOObjectCollection collection = (IOObjectCollection)this.collectionInput.getData();
        List<IOObject> elements = this.getParameterAsBoolean(PARAMETER_UNFOLD) ? collection.getObjectsRecursive() : collection.getObjects();
        int index = this.getParameterAsInt(PARAMETER_INDEX);
        if (index < 1 || index > elements.size()) {
            throw new UserError((Operator)this, 159, index, elements.size());
        }
        this.selectedOutput.deliver(elements.get(index - 1));
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeInt(PARAMETER_INDEX, "Index within the collection of the object to return", 1, Integer.MAX_VALUE, 1, false));
        types.add(new ParameterTypeBoolean(PARAMETER_UNFOLD, "If checked, collections are unfolded, i.e., if the collection contains other collections, the children will be concatenated and then the element at the given index will be looked up.", false));
        return types;
    }
}

