/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.collections;

import com.rapidminer.operator.IOObjectCollection;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.InputPortExtender;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.metadata.CollectionMetaData;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.SimpleMetaDataError;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import java.util.List;

public class CollectionOperator
extends Operator {
    public static final String PARAMETER_UNFOLD = "unfold";
    private final InputPortExtender inExtender = new InputPortExtender("input", this.getInputPorts());
    private final OutputPort collectionOutput = (OutputPort)this.getOutputPorts().createPort("collection");

    public CollectionOperator(OperatorDescription description) {
        super(description);
        this.inExtender.start();
        this.getTransformer().addRule(new MDTransformationRule(){

            @Override
            public void transformMD() {
                boolean unfold = CollectionOperator.this.getParameterAsBoolean(CollectionOperator.PARAMETER_UNFOLD);
                MetaData commonSupertype = null;
                for (InputPort in : CollectionOperator.this.inExtender.getManagedPorts()) {
                    MetaData md = in.getMetaData();
                    if (unfold && md instanceof CollectionMetaData) {
                        md = ((CollectionMetaData)md).getElementMetaDataRecursive();
                    }
                    if (md == null) continue;
                    if (commonSupertype == null) {
                        commonSupertype = md;
                        continue;
                    }
                    if (commonSupertype.getObjectClass().equals(md.getObjectClass())) continue;
                    if (commonSupertype.getObjectClass().isAssignableFrom(md.getObjectClass())) {
                        commonSupertype = md;
                        continue;
                    }
                    if (md.getObjectClass().isAssignableFrom(commonSupertype.getObjectClass())) continue;
                    in.addError(new SimpleMetaDataError(ProcessSetupError.Severity.WARNING, (Port)in, "incompatible_ioobjects", commonSupertype.getObjectClass().getSimpleName(), md.getObjectClass().getSimpleName()));
                    CollectionOperator.this.collectionOutput.deliverMD(new CollectionMetaData(new MetaData()));
                    return;
                }
                CollectionOperator.this.collectionOutput.deliverMD(new CollectionMetaData(commonSupertype));
            }
        });
    }

    @Override
    public void doWork() throws OperatorException {
        List list = this.inExtender.getData(this.getParameterAsBoolean(PARAMETER_UNFOLD));
        this.collectionOutput.deliver(new IOObjectCollection(list));
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeBoolean(PARAMETER_UNFOLD, "Determines whether collections received at the input ports are unfolded.", false));
        return types;
    }
}

