/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.collections;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.IOObjectCollection;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.CollectingPortPairExtender;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.CollectionMetaData;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.SubprocessTransformRule;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import java.util.List;

public class CollectionIterationOperator
extends OperatorChain {
    protected static final String PARAMETER_UNFOLD = "unfold";
    private final InputPort collectionInput = this.getInputPorts().createPort("collection", new CollectionMetaData(new MetaData()));
    private final OutputPort singleInnerSource = (OutputPort)this.getSubprocess(0).getInnerSources().createPort("single");
    private final CollectingPortPairExtender outExtender = new CollectingPortPairExtender("output", this.getSubprocess(0).getInnerSinks(), this.getOutputPorts());

    public CollectionIterationOperator(OperatorDescription description) {
        super(description, "Iteration");
        this.outExtender.start();
        this.getTransformer().addRule(new MDTransformationRule(){

            @Override
            public void transformMD() {
                MetaData md = CollectionIterationOperator.this.collectionInput.getMetaData();
                if (md != null && md instanceof CollectionMetaData) {
                    if (CollectionIterationOperator.this.getParameterAsBoolean(CollectionIterationOperator.PARAMETER_UNFOLD)) {
                        CollectionIterationOperator.this.singleInnerSource.deliverMD(((CollectionMetaData)md).getElementMetaDataRecursive());
                    } else {
                        CollectionIterationOperator.this.singleInnerSource.deliverMD(((CollectionMetaData)md).getElementMetaData());
                    }
                } else {
                    CollectionIterationOperator.this.singleInnerSource.deliverMD(null);
                }
            }
        });
        this.getTransformer().addRule(new SubprocessTransformRule(this.getSubprocess(0)));
        this.getTransformer().addRule(this.outExtender.makePassThroughRule());
    }

    @Override
    public void doWork() throws OperatorException {
        IOObjectCollection data = (IOObjectCollection)this.collectionInput.getData();
        List<IOObject> list = this.getParameterAsBoolean(PARAMETER_UNFOLD) ? data.getObjectsRecursive() : data.getObjects();
        this.outExtender.reset();
        for (IOObject o : list) {
            this.singleInnerSource.deliver(o);
            this.getSubprocess(0).execute();
            this.outExtender.collect();
        }
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeBoolean(PARAMETER_UNFOLD, "Determines if the input collection is unfolded.", false));
        return types;
    }
}

