/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.clustering.clusterer.soft;

import Jama.Matrix;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.clustering.ClusterModel;
import com.rapidminer.operator.clustering.FlatFuzzyClusterModel;
import com.rapidminer.operator.clustering.clusterer.KMeans;
import com.rapidminer.operator.clustering.clusterer.RMAbstractClusterer;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.OperatorService;
import com.rapidminer.tools.RandomGenerator;
import com.rapidminer.tools.math.VectorMath;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Vector;

public class EMClusterer
extends RMAbstractClusterer {
    public static final String PARAMETER_K = "k";
    public static final String PARAMETER_MAX_RUNS = "max_runs";
    public static final String PARAMETER_MAX_OPTIMIZATION_STEPS = "max_optimization_steps";
    public static final String PARAMETER_QUALITY = "quality";
    public static final String PARAMETER_SHOW_PROBABILITIES = "show_probabilities";
    public static final String PARAMETER_INITIALIZATION_DISTRIBUTION = "inital_distribution";
    public static final String[] INIT_DISTRIBUTION = new String[]{"randomly assigned examples", "k-means run", "average parameters"};
    public static final int RANDOMLY_ASSIGNED = 0;
    public static final int K_MEANS = 1;
    public static final int AVERAGE_PARAMETERS = 2;
    public static final String PARAMETER_CORRELATED = "correlated_attributes";

    public EMClusterer(OperatorDescription description) {
        super(description);
    }

    @Override
    protected Collection<AttributeMetaData> getAdditionalAttributes() {
        LinkedList<AttributeMetaData> propAttributes = new LinkedList<AttributeMetaData>();
        try {
            int k = this.getParameterAsInt(PARAMETER_K);
            for (int i = 0; i < k; ++i) {
                AttributeMetaData newAttr = new AttributeMetaData("cluster_" + i + "_probability", 4, "cluster_" + i + "_probability");
                propAttributes.add(newAttr);
            }
        }
        catch (UndefinedParameterError undefinedParameterError) {
            // empty catch block
        }
        return propAttributes;
    }

    public ClusterModel createClusterModel(ExampleSet exampleSet) throws OperatorException {
        FlatFuzzyClusterModel bestModel = null;
        int restoreMaxRuns = this.getParameterAsInt(PARAMETER_MAX_RUNS);
        boolean restoreCorrelated = this.getParameterAsBoolean(PARAMETER_CORRELATED);
        boolean isCorrelated = this.getParameterAsBoolean(PARAMETER_CORRELATED);
        int k = this.getParameterAsInt(PARAMETER_K);
        int initSpecialSize = exampleSet.getAttributes().specialSize();
        double[][] exampleInClusterProbability = new double[exampleSet.size()][k];
        double max = Double.NEGATIVE_INFINITY;
        int exceptionCounter = 0;
        for (int iter = 0; iter < this.getParameterAsInt(PARAMETER_MAX_RUNS); ++iter) {
            FlatFuzzyClusterModel result = new FlatFuzzyClusterModel(exampleSet, k, this.getParameterAsBoolean("add_as_label"), this.getParameterAsBoolean("remove_unlabeled"));
            FlatFuzzyClusterModel oldResult = null;
            try {
                this.init(exampleSet, result, k, initSpecialSize, exampleInClusterProbability);
            }
            catch (OperatorCreationException e1) {
                e1.printStackTrace();
            }
            boolean stableState = false;
            double logLikelyHood_old = Double.POSITIVE_INFINITY;
            double logLikelyHood = 0.0;
            int optiStep = 0;
            int[] clusterAssignments = new int[exampleSet.size()];
            try {
                for (optiStep = 0; optiStep < this.getParameterAsInt(PARAMETER_MAX_OPTIMIZATION_STEPS) && !stableState; ++optiStep) {
                    stableState = true;
                    oldResult = result;
                    result = new FlatFuzzyClusterModel(exampleSet, k, this.getParameterAsBoolean("add_as_label"), this.getParameterAsBoolean("remove_unlabeled"));
                    if (isCorrelated) {
                        this.expectationCorrelated(exampleSet, k, exampleInClusterProbability, oldResult);
                    } else {
                        this.expectationNonCorrelated(exampleSet, k, exampleInClusterProbability, oldResult);
                    }
                    for (int exampleIndex = 0; exampleIndex < exampleSet.size(); ++exampleIndex) {
                        int bestIndex = this.bestIndex(exampleIndex, k, exampleInClusterProbability);
                        if (bestIndex < 0) {
                            bestIndex = RandomGenerator.getGlobalRandomGenerator().nextInt(result.getNumberOfClusters());
                        }
                        clusterAssignments[exampleIndex] = bestIndex;
                    }
                    result.setClusterAssignments(clusterAssignments, exampleSet);
                    this.maximization(exampleSet, k, exampleInClusterProbability, result);
                    logLikelyHood = this.computeLogLikelyhood(k, exampleInClusterProbability, result);
                    double difference = logLikelyHood_old - logLikelyHood;
                    if (!(Math.abs(difference) < this.getParameterAsDouble(PARAMETER_QUALITY))) {
                        stableState = false;
                    }
                    logLikelyHood_old = logLikelyHood;
                }
            }
            catch (Exception e) {
                if (++exceptionCounter > restoreMaxRuns) {
                    if ((long)(iter - (exceptionCounter - 1)) >= Math.round((double)restoreMaxRuns * 0.49)) break;
                    this.getLogger().info("Can't compute the inverse of the covariance matrix. Maybe the Matrix is singular. Changing option \"correlated_attributes\" to false.");
                    this.setParameter(PARAMETER_CORRELATED, "false");
                    this.setParameter(PARAMETER_MAX_RUNS, "" + restoreMaxRuns);
                    bestModel = (FlatFuzzyClusterModel)this.createClusterModel(exampleSet);
                    break;
                }
                this.setParameter(PARAMETER_MAX_RUNS, "" + (this.getParameterAsInt(PARAMETER_MAX_RUNS) + 1));
                continue;
            }
            if (!(Math.abs(logLikelyHood) > max)) continue;
            max = Math.abs(logLikelyHood);
            bestModel = result;
            if (!this.showProbs()) continue;
            this.setProbabilitiesInTable(exampleSet, exampleInClusterProbability);
            bestModel.setExampleInClusterProbability(exampleInClusterProbability);
        }
        this.setParameter(PARAMETER_MAX_RUNS, "" + restoreMaxRuns);
        this.setParameter(PARAMETER_CORRELATED, "" + restoreCorrelated);
        return bestModel;
    }

    private void init(ExampleSet exampleSet, FlatFuzzyClusterModel result, int k, int initSpecialSize, double[][] exampleInClusterProbability) throws OperatorException, OperatorCreationException {
        int distribution = this.getParameterAsInt(PARAMETER_INITIALIZATION_DISTRIBUTION);
        switch (distribution) {
            case 0: {
                double[][] clusterMeans;
                try {
                    int clustersFilled;
                    RandomGenerator random = RandomGenerator.getRandomGenerator(this);
                    do {
                        clustersFilled = 0;
                        clusterMeans = new double[k][exampleSet.getAttributes().size()];
                        int i = 0;
                        for (Example ex : exampleSet) {
                            int cluster = random.nextInt(k);
                            exampleInClusterProbability[i][cluster] = 1.0;
                            int j = 0;
                            for (Attribute attribute : exampleSet.getAttributes()) {
                                double[] dArray = clusterMeans[cluster];
                                int n = j++;
                                dArray[n] = dArray[n] + ex.getValue(attribute);
                            }
                            ++i;
                        }
                        block9: for (i = 0; i < k; ++i) {
                            result.setClusterMean(i, clusterMeans[i]);
                            for (int j = 0; j < exampleInClusterProbability.length; ++j) {
                                if (exampleInClusterProbability[j][i] != 1.0) continue;
                                ++clustersFilled;
                                continue block9;
                            }
                        }
                    } while (clustersFilled < k);
                }
                catch (UndefinedParameterError e) {
                    // empty catch block
                }
                this.computeValuesWithClusterMemberships(exampleSet, k, exampleInClusterProbability, result);
                if (!this.isCorrelated()) break;
                this.initCovarianceMatrix(exampleSet, exampleInClusterProbability, result, k);
                break;
            }
            case 1: {
                KMeans clusterAlgorithm = OperatorService.createOperator(KMeans.class);
                ExampleSet clusterSet = (ExampleSet)exampleSet.clone();
                clusterAlgorithm.setParameter(PARAMETER_K, "" + k);
                clusterAlgorithm.setParameter("add_cluster_attribute", "true");
                clusterAlgorithm.generateClusterModel(clusterSet);
                double[][] clusterMeans = new double[k][exampleSet.getAttributes().size()];
                int exampleIndex = 0;
                Attribute clusterAttribute = clusterSet.getAttributes().getCluster();
                for (Example example : clusterSet) {
                    int clusterIndex = (int)example.getValue(clusterAttribute);
                    exampleInClusterProbability[exampleIndex][clusterIndex] = 1.0;
                    int j = 0;
                    for (Attribute attribute : clusterSet.getAttributes()) {
                        double[] dArray = clusterMeans[clusterIndex];
                        int n = j++;
                        dArray[n] = dArray[n] + example.getValue(attribute);
                    }
                    ++exampleIndex;
                }
                for (int i = 0; i < k; ++i) {
                    result.setClusterMean(i, clusterMeans[i]);
                }
                this.computeValuesWithClusterMemberships(exampleSet, k, exampleInClusterProbability, result);
                if (!this.isCorrelated()) break;
                this.initCovarianceMatrix(exampleSet, exampleInClusterProbability, result, k);
                break;
            }
            default: {
                RandomGenerator random = RandomGenerator.getRandomGenerator(this);
                this.initAverageParameters(exampleSet, k, exampleInClusterProbability, result, random);
            }
        }
        if (this.showProbs() && exampleSet.getAttributes().specialSize() == initSpecialSize) {
            for (int i = 0; i < k; ++i) {
                String name = "cluster_" + i + "_probability";
                Attribute newAttribute = AttributeFactory.createAttribute(4);
                newAttribute.setName(name);
                exampleSet.getExampleTable().addAttribute(newAttribute);
                exampleSet.getAttributes().setSpecialAttribute(newAttribute, name);
            }
            this.setProbabilitiesInTable(exampleSet, exampleInClusterProbability);
        }
    }

    private void computeValuesWithClusterMemberships(ExampleSet exampleSet, int k, double[][] exampleInClusterProbability, FlatFuzzyClusterModel result) {
        int denominator;
        int i;
        for (i = 0; i < k; ++i) {
            denominator = 0;
            for (int j = 0; j < exampleInClusterProbability.length; ++j) {
                if (exampleInClusterProbability[j][i] != 1.0) continue;
                ++denominator;
            }
            double[] clusterMean = new double[result.getClusterMean(i).length];
            for (int j = 0; j < result.getClusterMean(i).length; ++j) {
                clusterMean[j] = result.getClusterMean(i)[j] / (double)denominator;
            }
            result.setClusterMean(i, clusterMean);
        }
        for (i = 0; i < k; ++i) {
            denominator = 0;
            double clusterStDeviation = 0.0;
            for (int j = 0; j < exampleInClusterProbability.length; ++j) {
                if (exampleInClusterProbability[j][i] != 1.0) continue;
                double[] helpVector = VectorMath.vectorSubtraction(this.exampleToArray(exampleSet.getExample(j)), result.getClusterMean(i));
                clusterStDeviation += VectorMath.vectorMultiplication(helpVector, helpVector);
                ++denominator;
            }
            result.setClusterStandardDeviation(i, clusterStDeviation / (double)denominator);
            result.setClusterProbability(i, (double)denominator / (double)exampleSet.size());
        }
    }

    private void initCovarianceMatrix(ExampleSet exampleSet, double[][] exampleInClusterProbability, FlatFuzzyClusterModel result, int k) {
        this.expectationNonCorrelated(exampleSet, k, exampleInClusterProbability, result);
        this.computeCovarianceMatrix(exampleSet, exampleInClusterProbability, result, k);
        result.clearClusterStandardDeviations();
    }

    private void initAverageParameters(ExampleSet exampleSet, int k, double[][] exampleInClusterProbability, FlatFuzzyClusterModel result, Random random) {
        double[] max = new double[exampleSet.getAttributes().size()];
        double[] min = new double[exampleSet.getAttributes().size()];
        double[] average = new double[exampleSet.getAttributes().size()];
        for (int j = 0; j < min.length; ++j) {
            min[j] = Double.POSITIVE_INFINITY;
        }
        int i = 0;
        for (Example ex : exampleSet) {
            int j = 0;
            for (Attribute attribute : exampleSet.getAttributes()) {
                double value = ex.getValue(attribute);
                int n = j;
                average[n] = average[n] + value;
                if (value < min[j]) {
                    min[j] = value;
                } else if (value > max[j]) {
                    max[j] = value;
                }
                ++j;
            }
            ++i;
        }
        for (int j = 0; j < average.length; ++j) {
            average[j] = average[j] / (double)exampleSet.size();
        }
        double[] offset = VectorMath.vectorDivision(VectorMath.vectorSubtraction(max, min), k * 2);
        min = VectorMath.vectorAddition(min, this.getOffset(offset, random));
        average = VectorMath.vectorAddition(average, this.getOffset(offset, random));
        max = VectorMath.vectorAddition(max, this.getOffset(offset, random));
        double[] help = VectorMath.vectorSubtraction(average, min);
        help = VectorMath.vectorDivision(help, k / 2 + 1);
        double[] help2 = VectorMath.vectorSubtraction(max, average);
        help2 = VectorMath.vectorDivision(help2, k / 2 + 1);
        int j = 0;
        for (i = 0; i < k; ++i) {
            double clusterStDeviation;
            double[] clusterMean = new double[exampleSet.getAttributes().size()];
            if (i < k / 2) {
                clusterMean = VectorMath.vectorAddition(VectorMath.vectorMultiplication(help, i + 1), min);
                clusterStDeviation = VectorMath.vectorMultiplication(help, help);
            } else if (i == k / 2 && k % 2 == 1) {
                clusterMean = average;
                double[] help3 = VectorMath.vectorMultiplication(help, -1.0);
                clusterStDeviation = VectorMath.vectorMultiplication(help3, help3);
                clusterStDeviation += VectorMath.vectorMultiplication(help2, help2);
                clusterStDeviation /= 2.0;
            } else {
                clusterMean = VectorMath.vectorAddition(average, VectorMath.vectorMultiplication(help2, j + 1));
                clusterStDeviation = VectorMath.vectorMultiplication(help2, help2);
                ++j;
            }
            double clusterProbability = 1.0 / (double)k;
            result.setClusterMean(i, clusterMean);
            result.setClusterStandardDeviation(i, clusterStDeviation);
            result.setClusterProbability(i, clusterProbability);
        }
        if (this.isCorrelated()) {
            this.initCovarianceMatrix(exampleSet, exampleInClusterProbability, result, k);
        }
    }

    private double[] getOffset(double[] offset, Random random) {
        double multi = 2.0 * random.nextDouble() - 1.0;
        return VectorMath.vectorMultiplication(offset, multi);
    }

    protected int bestIndex(int exampleIndex, int k, double[][] exampleInClusterProbability) throws Exception {
        int bestIndex = -1;
        double bestIndexValue = 0.0;
        for (int i = 0; i < k; ++i) {
            if (!(bestIndexValue < exampleInClusterProbability[exampleIndex][i])) continue;
            bestIndexValue = exampleInClusterProbability[exampleIndex][i];
            bestIndex = i;
        }
        return bestIndex;
    }

    protected void expectationNonCorrelated(ExampleSet exampleSet, int k, double[][] exampleInClusterProbability, FlatFuzzyClusterModel oldResult) {
        int j = 0;
        for (Example ex : exampleSet) {
            int i;
            double sum = 0.0;
            for (i = 0; i < k; ++i) {
                double[] helpVector = VectorMath.vectorSubtraction(this.exampleToArray(ex), oldResult.getClusterMean(i));
                double stDev = oldResult.getClusterStandardDeviation(i);
                if (stDev == 0.0) {
                    stDev = 1.0E-10;
                }
                exampleInClusterProbability[j][i] = 1.0 / Math.sqrt(Math.pow(Math.PI * 2 * stDev, exampleSet.getAttributes().size())) * Math.exp(-1.0 * (VectorMath.vectorMultiplication(helpVector, helpVector) / (2.0 * stDev))) * oldResult.getClusterProbability(i);
                sum += exampleInClusterProbability[j][i];
            }
            for (i = 0; i < k; ++i) {
                exampleInClusterProbability[j][i] = exampleInClusterProbability[j][i] / sum;
            }
            ++j;
        }
    }

    protected void expectationCorrelated(ExampleSet exampleSet, int k, double[][] exampleInClusterProbability, FlatFuzzyClusterModel oldResult) throws Exception {
        int j = 0;
        for (Example ex : exampleSet) {
            int i;
            double sum = 0.0;
            Vector<Integer> problems = new Vector<Integer>();
            for (i = 0; i < k; ++i) {
                double[] helpVector = VectorMath.vectorSubtraction(this.exampleToArray(ex), oldResult.getClusterMean(i));
                double[][] helpMatrix = new double[helpVector.length][1];
                for (int l = 0; l < helpVector.length; ++l) {
                    helpMatrix[l][0] = helpVector[l];
                }
                Matrix matrix = new Matrix(helpMatrix);
                matrix = matrix.transpose().times(new Matrix(oldResult.getClusterCovarianceMatrix(i)).inverse()).times(matrix);
                double secondPart = Math.exp(matrix.getArray()[0][0] * -0.5);
                double determinant = new Matrix(oldResult.getClusterCovarianceMatrix(i)).det();
                if (determinant < 0.0) {
                    determinant *= -1.0;
                }
                exampleInClusterProbability[j][i] = 1.0 / Math.sqrt(Math.pow(Math.PI * 2, exampleSet.getAttributes().size()) * determinant) * secondPart * oldResult.getClusterProbability(i);
                if (exampleInClusterProbability[j][i] == Double.POSITIVE_INFINITY) {
                    problems.add(i);
                }
                sum += exampleInClusterProbability[j][i];
            }
            for (i = 0; i < k; ++i) {
                exampleInClusterProbability[j][i] = problems.isEmpty() ? exampleInClusterProbability[j][i] / sum : (exampleInClusterProbability[j][i] == Double.POSITIVE_INFINITY ? 1.0 : 0.0);
            }
            ++j;
        }
    }

    protected void maximization(ExampleSet exampleSet, int k, double[][] exampleInClusterProbability, FlatFuzzyClusterModel result) {
        for (int i = 0; i < k; ++i) {
            double probabilitySum = 0.0;
            int j = 0;
            double[] clusterMean = new double[exampleSet.getAttributes().size()];
            for (Example example : exampleSet) {
                probabilitySum += exampleInClusterProbability[j][i];
                clusterMean = VectorMath.vectorAddition(clusterMean, VectorMath.vectorMultiplication(this.exampleToArray(example), exampleInClusterProbability[j][i]));
                ++j;
            }
            result.setClusterMean(i, VectorMath.vectorDivision(clusterMean, probabilitySum));
            result.setClusterProbability(i, probabilitySum / (double)exampleSet.size());
            if (this.isCorrelated()) continue;
            j = 0;
            double clusterStDeviation = 0.0;
            for (Example example : exampleSet) {
                double[] helpVector = VectorMath.vectorSubtraction(this.exampleToArray(example), result.getClusterMean(i));
                clusterStDeviation += exampleInClusterProbability[j][i] * VectorMath.vectorMultiplication(helpVector, helpVector);
                ++j;
            }
            result.setClusterStandardDeviation(i, clusterStDeviation / probabilitySum);
        }
        if (this.isCorrelated()) {
            this.computeCovarianceMatrix(exampleSet, exampleInClusterProbability, result, k);
        }
    }

    private void computeCovarianceMatrix(ExampleSet exampleSet, double[][] exampleInClusterProbability, FlatFuzzyClusterModel result, int k) {
        for (int i = 0; i < k; ++i) {
            Matrix matrix_old = null;
            Matrix matrix = null;
            double probSum = 0.0;
            int id = 0;
            for (Example example : exampleSet) {
                double[] helpVector = VectorMath.vectorSubtraction(this.exampleToArray(example), result.getClusterMean(i));
                double[][] helpMatrix = new double[helpVector.length][1];
                for (int j = 0; j < helpVector.length; ++j) {
                    helpMatrix[j][0] = helpVector[j];
                }
                matrix = new Matrix(helpMatrix);
                matrix = matrix.times(matrix.transpose()).times(exampleInClusterProbability[id][i]);
                probSum += exampleInClusterProbability[id][i];
                if (matrix_old != null) {
                    matrix = matrix_old.plus(matrix);
                }
                matrix_old = matrix;
                ++id;
            }
            double[][] covarianceMatrix = matrix.getArray();
            covarianceMatrix = VectorMath.matrixDivision(covarianceMatrix, probSum);
            result.setClusterCovarianceMatrix(i, covarianceMatrix);
        }
    }

    protected double computeLogLikelyhood(int k, double[][] exampleInClusterProbability, FlatFuzzyClusterModel resultModel) {
        double result = 0.0;
        double temp = 0.0;
        for (int n = 0; n < exampleInClusterProbability.length; ++n) {
            for (int i = 0; i < k; ++i) {
                temp += resultModel.getClusterProbability(i) * exampleInClusterProbability[n][i];
            }
            result += Math.log(temp);
        }
        return result;
    }

    private boolean showProbs() {
        return this.getParameterAsBoolean(PARAMETER_SHOW_PROBABILITIES);
    }

    private boolean isCorrelated() {
        return this.getParameterAsBoolean(PARAMETER_CORRELATED);
    }

    private void setProbabilitiesInTable(ExampleSet exampleSet, double[][] exampleInClusterProbability) throws OperatorException {
        for (int i = 0; i < this.getParameterAsInt(PARAMETER_K); ++i) {
            String name = "cluster_" + i + "_probability";
            int j = 0;
            for (Example ex : exampleSet) {
                ex.setValue(exampleSet.getAttributes().get(name), exampleInClusterProbability[j][i]);
                ++j;
            }
        }
    }

    private double[] exampleToArray(Example example) {
        double[] result = new double[example.getAttributes().size()];
        int i = 0;
        for (Attribute attribute : example.getAttributes()) {
            result[i] = example.getValue(attribute);
            ++i;
        }
        return result;
    }

    @Override
    public ClusterModel generateClusterModel(ExampleSet exampleSet) throws OperatorException {
        ClusterModel model;
        block5: {
            int k = this.getParameterAsInt(PARAMETER_K);
            Tools.isNonEmpty(exampleSet);
            Tools.checkAndCreateIds(exampleSet);
            if (exampleSet.size() < k) {
                this.logWarning("number of clusters (k) = " + k + " > number of objects =" + exampleSet.size());
                throw new UserError((Operator)this, 142, k);
            }
            model = this.createClusterModel(exampleSet);
            Attribute idAttribute = exampleSet.getAttributes().getId();
            if (!this.addsClusterAttribute()) break block5;
            Attribute cluster = AttributeFactory.createAttribute("cluster", 1);
            exampleSet.getExampleTable().addAttribute(cluster);
            exampleSet.getAttributes().setCluster(cluster);
            int i = 0;
            if (idAttribute.isNumerical()) {
                for (Example example : exampleSet) {
                    example.setValue(cluster, "cluster_" + model.getClusterIndexOfId(example.getValue(idAttribute)));
                    ++i;
                }
            } else {
                for (Example example : exampleSet) {
                    example.setValue(cluster, "cluster_" + model.getClusterIndexOfId(example.getValueAsString(idAttribute)));
                    ++i;
                }
            }
        }
        return model;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        ParameterTypeInt type = new ParameterTypeInt(PARAMETER_K, "The number of clusters which should be found.", 2, Integer.MAX_VALUE, 2);
        type.setExpert(false);
        types.add(type);
        types.addAll(super.getParameterTypes());
        types.add(new ParameterTypeInt(PARAMETER_MAX_RUNS, "The maximal number of runs of this operator with random initialization that are performed.", 1, Integer.MAX_VALUE, 5, false));
        types.add(new ParameterTypeInt(PARAMETER_MAX_OPTIMIZATION_STEPS, "The maximal number of iterations performed for one run of this operator.", 1, Integer.MAX_VALUE, 100, false));
        types.add(new ParameterTypeDouble(PARAMETER_QUALITY, "The quality that must be fullfilled before the algorithm stops. (The rising of the loglikelyhood that must be undercut)", 1.0E-15, 0.1, 1.0E-10));
        types.addAll(RandomGenerator.getRandomGeneratorParameters(this));
        types.add(new ParameterTypeBoolean(PARAMETER_SHOW_PROBABILITIES, "Insert probabilities for every cluster with every example in the example set.", true));
        types.add(new ParameterTypeCategory(PARAMETER_INITIALIZATION_DISTRIBUTION, "Indicates the inital distribution of the centroids.", INIT_DISTRIBUTION, 1));
        types.add(new ParameterTypeBoolean(PARAMETER_CORRELATED, "Has to be activated, if the example set contains correlated attributes.", true));
        return types;
    }
}

