/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.clustering.clusterer;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.example.set.Partition;
import com.rapidminer.example.set.SplittedExampleSet;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.clustering.ClusterModel;
import com.rapidminer.operator.clustering.ClusterModel2ExampleSet;
import com.rapidminer.operator.clustering.FlattenClusterModel;
import com.rapidminer.operator.clustering.HierarchicalClusterLeafNode;
import com.rapidminer.operator.clustering.HierarchicalClusterModel;
import com.rapidminer.operator.clustering.HierarchicalClusterNode;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetPassThroughRule;
import com.rapidminer.operator.ports.metadata.GenerateNewMDRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.PassThroughRule;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.operator.ports.metadata.SimplePrecondition;
import com.rapidminer.operator.ports.metadata.SubprocessTransformRule;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.tools.OperatorService;
import com.rapidminer.tools.metadata.MetaDataTools;
import java.util.LinkedList;
import java.util.List;

public class TopDownClustering
extends OperatorChain {
    private InputPort exampleSetInput = (InputPort)this.getInputPorts().createPort("example set");
    private OutputPort modelOutput = (OutputPort)this.getOutputPorts().createPort("cluster model");
    private OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("clustered set");
    private OutputPort exampleSetInnerSource = (OutputPort)this.getSubprocess(0).getInnerSources().createPort("example set");
    private InputPort modelInnerSink = (InputPort)this.getSubprocess(0).getInnerSinks().createPort("cluster model");
    public static final String PARAMETER_MAX_LEAF_SIZE = "max_leaf_size";
    public static final String PARAMETER_MAX_DEPTH = "max_depth";
    public static final String PARAMETER_CREATE_CLUSTER_LABEL = "create_cluster_label";

    public TopDownClustering(OperatorDescription description) {
        super(description, "Clustering Process");
        this.exampleSetInput.addPrecondition(new SimplePrecondition(this.exampleSetInput, new ExampleSetMetaData()));
        this.getTransformer().addRule(new PassThroughRule(this.exampleSetInput, this.exampleSetInnerSource, false));
        this.getTransformer().addRule(new SubprocessTransformRule(this.getSubprocess(0)));
        this.modelInnerSink.addPrecondition(new SimplePrecondition(this.modelInnerSink, new MetaData(ClusterModel.class)));
        this.getTransformer().addRule(new ExampleSetPassThroughRule(this.exampleSetInput, this.exampleSetOutput, SetRelation.EQUAL){

            @Override
            public ExampleSetMetaData modifyExampleSet(ExampleSetMetaData metaData) {
                if (TopDownClustering.this.addsClusterAttribute()) {
                    metaData.addAttribute(new AttributeMetaData("cluster", 1, "cluster"));
                }
                MetaDataTools.checkAndCreateIds(metaData);
                return metaData;
            }
        });
        this.getTransformer().addRule(new GenerateNewMDRule(this.modelOutput, new MetaData(HierarchicalClusterModel.class)));
    }

    private boolean addsClusterAttribute() {
        return this.getParameterAsBoolean(PARAMETER_CREATE_CLUSTER_LABEL);
    }

    @Override
    public void doWork() throws OperatorException {
        ExampleSet exampleSet = (ExampleSet)this.exampleSetInput.getData();
        int maxLeafSize = this.getParameterAsInt(PARAMETER_MAX_LEAF_SIZE);
        Tools.checkAndCreateIds(exampleSet);
        Tools.onlyNonMissingValues(exampleSet, "AgglomerativeClustering");
        HierarchicalClusterNode root = new HierarchicalClusterNode("root");
        HierarchicalClusterModel model = new HierarchicalClusterModel(root);
        int createdLeafs = this.descend(exampleSet, root, 0, maxLeafSize, this.getParameterAsInt(PARAMETER_MAX_DEPTH) - 1);
        if (this.getParameterAsBoolean(PARAMETER_CREATE_CLUSTER_LABEL) && this.exampleSetOutput.isConnected()) {
            try {
                FlattenClusterModel flattener = OperatorService.createOperator(FlattenClusterModel.class);
                flattener.setParameter("number_of_clusters", createdLeafs + "");
                ClusterModel flatModel = flattener.flatten(model, exampleSet);
                ClusterModel2ExampleSet applier = OperatorService.createOperator(ClusterModel2ExampleSet.class);
                ExampleSet labelledExampleSet = applier.addClusterAttribute(exampleSet, flatModel);
                this.exampleSetOutput.deliver(labelledExampleSet);
                this.modelOutput.deliver(model);
            }
            catch (OperatorCreationException e) {
                throw new OperatorException("Could not create FlattenClusterModel Operator: " + e, e);
            }
        } else {
            Attribute clusterAttribute = exampleSet.getAttributes().getCluster();
            if (clusterAttribute != null) {
                exampleSet.getAttributes().remove(clusterAttribute);
            }
            this.exampleSetOutput.deliver(exampleSet);
            this.modelOutput.deliver(model);
        }
    }

    private int descend(ExampleSet exampleSet, HierarchicalClusterNode elter, int depth, int maxLeafSize, int maxDepth) throws OperatorException {
        Tools.checkAndCreateIds(exampleSet);
        this.exampleSetInnerSource.deliver(exampleSet);
        this.getSubprocess(0).execute();
        ClusterModel currentModel = (ClusterModel)this.modelInnerSink.getData();
        int[] clusterAssignments = currentModel.getClusterAssignments(exampleSet);
        Partition partition = new Partition(clusterAssignments, currentModel.getNumberOfClusters());
        SplittedExampleSet splittedSet = new SplittedExampleSet(exampleSet, partition);
        int numberOfCreatedLeafs = 0;
        for (int i = 0; i < currentModel.getNumberOfClusters(); ++i) {
            splittedSet.selectSingleSubset(i);
            if (splittedSet.size() > maxLeafSize && depth < maxDepth) {
                HierarchicalClusterNode node = new HierarchicalClusterNode(depth + ":" + i);
                elter.addSubNode(node);
                numberOfCreatedLeafs += this.descend(splittedSet, node, depth + 1, maxLeafSize, maxDepth);
                continue;
            }
            LinkedList<Object> exampleIds = new LinkedList<Object>();
            Attribute id = splittedSet.getAttributes().getId();
            if (id.isNominal()) {
                for (Example example : splittedSet) {
                    exampleIds.add(example.getValueAsString(id));
                }
            } else {
                for (Example example : splittedSet) {
                    exampleIds.add(example.getValue(id));
                }
            }
            HierarchicalClusterLeafNode leaf = new HierarchicalClusterLeafNode(depth + ":" + i, exampleIds);
            elter.addSubNode(leaf);
            ++numberOfCreatedLeafs;
        }
        return numberOfCreatedLeafs;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeBoolean(PARAMETER_CREATE_CLUSTER_LABEL, "Specifies if a cluster label should be created.", true);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_MAX_DEPTH, "The maximal depth of cluster tree.", 1, Integer.MAX_VALUE, 5);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeInt(PARAMETER_MAX_LEAF_SIZE, "The maximal number of items in each cluster leaf.", 1, Integer.MAX_VALUE, 1));
        return types;
    }
}

