/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.clustering.clusterer;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.clustering.ClusterModel;
import com.rapidminer.operator.clustering.clusterer.RMAbstractClusterer;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.tools.RandomGenerator;
import java.util.List;

public class RandomClustering
extends RMAbstractClusterer {
    public static final String PARAMETER_NUMBER_OF_CLUSTERS = "number_of_clusters";

    public RandomClustering(OperatorDescription description) {
        super(description);
    }

    @Override
    public ClusterModel generateClusterModel(ExampleSet exampleSet) throws OperatorException {
        Tools.checkAndCreateIds(exampleSet);
        RandomGenerator random = RandomGenerator.getRandomGenerator(this);
        int[] clusterAssignments = new int[exampleSet.size()];
        int k = this.getParameterAsInt(PARAMETER_NUMBER_OF_CLUSTERS);
        for (int i = 0; i < exampleSet.size(); ++i) {
            clusterAssignments[i] = random.nextInt(k);
        }
        ClusterModel model = new ClusterModel(exampleSet, k, this.getParameterAsBoolean("add_as_label"), this.getParameterAsBoolean("remove_unlabeled"));
        model.setClusterAssignments(clusterAssignments, exampleSet);
        if (this.addsClusterAttribute()) {
            Attribute cluster = AttributeFactory.createAttribute("cluster", 1);
            exampleSet.getExampleTable().addAttribute(cluster);
            exampleSet.getAttributes().setCluster(cluster);
            int i = 0;
            for (Example example : exampleSet) {
                example.setValue(cluster, "cluster_" + clusterAssignments[i]);
                ++i;
            }
        }
        return model;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeInt type = new ParameterTypeInt(PARAMETER_NUMBER_OF_CLUSTERS, "Specifies the desired number of clusters.", 2, Integer.MAX_VALUE, 3);
        type.setExpert(false);
        types.add(type);
        types.addAll(RandomGenerator.getRandomGeneratorParameters(this));
        return types;
    }
}

