/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.clustering.clusterer;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.clustering.ClusterModel;
import com.rapidminer.operator.clustering.clusterer.RMAbstractClusterer;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.tools.RandomGenerator;
import com.rapidminer.tools.math.kernels.Kernel;
import java.util.ArrayList;
import java.util.List;

public class KernelKMeans
extends RMAbstractClusterer {
    public static final String PARAMETER_K = "k";
    public static final String PARAMETER_USE_WEIGHTS = "use_weights";
    public static final String PARAMETER_MAX_OPTIMIZATION_STEPS = "max_optimization_steps";

    public KernelKMeans(OperatorDescription description) {
        super(description);
    }

    @Override
    public ClusterModel generateClusterModel(ExampleSet exampleSet) throws OperatorException {
        int k = this.getParameterAsInt(PARAMETER_K);
        int maxOptimizationSteps = this.getParameterAsInt(PARAMETER_MAX_OPTIMIZATION_STEPS);
        boolean useExampleWeights = this.getParameterAsBoolean(PARAMETER_USE_WEIGHTS);
        Kernel kernel = Kernel.createKernel(this);
        Tools.checkAndCreateIds(exampleSet);
        Tools.onlyNonMissingValues(exampleSet, "KernelKMeans");
        if (exampleSet.size() < k) {
            throw new UserError((Operator)this, 142, k);
        }
        Attributes attributes = exampleSet.getAttributes();
        ArrayList<String> attributeNames = new ArrayList<String>(attributes.size());
        for (Attribute attribute : attributes) {
            attributeNames.add(attribute.getName());
        }
        Attribute weightAttribute = attributes.getWeight();
        RandomGenerator generator = RandomGenerator.getRandomGenerator(this);
        ClusterModel model = new ClusterModel(exampleSet, k, this.getParameterAsBoolean("add_as_label"), this.getParameterAsBoolean("remove_unlabeled"));
        int[] clusterAssignments = new int[exampleSet.size()];
        for (int i = 0; i < exampleSet.size(); ++i) {
            clusterAssignments[i] = generator.nextIntInRange(0, k);
        }
        boolean stable = false;
        for (int step = 0; step < maxOptimizationSteps && !stable; ++step) {
            this.checkForStop();
            double[] clusterWeights = new double[k];
            double[] clusterKernelCorrection = new double[k];
            int i = 0;
            for (Example firstExample : exampleSet) {
                double firstExampleWeight = useExampleWeights ? firstExample.getValue(weightAttribute) : 1.0;
                double[] firstExampleValues = this.getAsDoubleArray(firstExample, attributes);
                int n = clusterAssignments[i];
                clusterWeights[n] = clusterWeights[n] + firstExampleWeight;
                int j = 0;
                for (Example secondExample : exampleSet) {
                    if (clusterAssignments[i] == clusterAssignments[j]) {
                        double secondExampleWeight = useExampleWeights ? secondExample.getValue(weightAttribute) : 1.0;
                        int n2 = clusterAssignments[i];
                        clusterKernelCorrection[n2] = clusterKernelCorrection[n2] + firstExampleWeight * secondExampleWeight * kernel.calculateDistance(firstExampleValues, this.getAsDoubleArray(secondExample, attributes));
                    }
                    ++j;
                }
                ++i;
            }
            for (int z = 0; z < k; ++z) {
                int n = z;
                clusterKernelCorrection[n] = clusterKernelCorrection[n] / (clusterWeights[z] * clusterWeights[z]);
            }
            int[] newClusterAssignments = new int[exampleSet.size()];
            i = 0;
            for (Example example : exampleSet) {
                double[] exampleValues = this.getAsDoubleArray(example, attributes);
                double exampleKernelValue = kernel.calculateDistance(exampleValues, exampleValues);
                double nearestDistance = Double.POSITIVE_INFINITY;
                int nearestIndex = 0;
                for (int clusterIndex = 0; clusterIndex < k; ++clusterIndex) {
                    double distance = 0.0;
                    int j = 0;
                    for (Example clusterExample : exampleSet) {
                        if (clusterAssignments[j] == clusterIndex) {
                            distance += (useExampleWeights ? clusterExample.getValue(weightAttribute) : 1.0) * kernel.calculateDistance(this.getAsDoubleArray(clusterExample, attributes), exampleValues);
                        }
                        ++j;
                    }
                    distance *= -2.0 / clusterWeights[clusterIndex];
                    distance += exampleKernelValue;
                    if (!((distance += clusterKernelCorrection[clusterIndex]) < nearestDistance)) continue;
                    nearestDistance = distance;
                    nearestIndex = clusterIndex;
                }
                newClusterAssignments[i] = nearestIndex;
                ++i;
            }
            stable = true;
            for (int j = 0; j < exampleSet.size() && stable; stable &= newClusterAssignments[j] == clusterAssignments[j], ++j) {
            }
            clusterAssignments = newClusterAssignments;
        }
        model.setClusterAssignments(clusterAssignments, exampleSet);
        if (this.addsClusterAttribute()) {
            Attribute cluster = AttributeFactory.createAttribute("cluster", 1);
            exampleSet.getExampleTable().addAttribute(cluster);
            exampleSet.getAttributes().setCluster(cluster);
            int i = 0;
            for (Example example : exampleSet) {
                example.setValue(cluster, "cluster_" + clusterAssignments[i]);
                ++i;
            }
        }
        return model;
    }

    private double[] getAsDoubleArray(Example example, Attributes attributes) {
        double[] values = new double[attributes.size()];
        int i = 0;
        for (Attribute attribute : attributes) {
            values[i] = example.getValue(attribute);
            ++i;
        }
        return values;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeBoolean(PARAMETER_USE_WEIGHTS, "Indicates if the weight attribute should be used.", false, false));
        types.add(new ParameterTypeInt(PARAMETER_K, "The number of clusters which should be detected.", 2, Integer.MAX_VALUE, 2, false));
        types.add(new ParameterTypeInt(PARAMETER_MAX_OPTIMIZATION_STEPS, "The maximal number of iterations performed for one run of k-Means.", 1, Integer.MAX_VALUE, 100, false));
        types.addAll(RandomGenerator.getRandomGeneratorParameters(this));
        types.addAll(Kernel.getParameters(this));
        return types;
    }
}

