/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.clustering.clusterer;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCapability;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.clustering.CentroidClusterModel;
import com.rapidminer.operator.clustering.ClusterModel;
import com.rapidminer.operator.clustering.clusterer.RMAbstractClusterer;
import com.rapidminer.operator.learner.CapabilityProvider;
import com.rapidminer.operator.ports.metadata.DistanceMeasurePrecondition;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.tools.RandomGenerator;
import com.rapidminer.tools.math.similarity.DistanceMeasure;
import com.rapidminer.tools.math.similarity.DistanceMeasureHelper;
import com.rapidminer.tools.math.similarity.DistanceMeasures;
import java.util.ArrayList;
import java.util.List;

public class KMedoids
extends RMAbstractClusterer
implements CapabilityProvider {
    public static final String PARAMETER_K = "k";
    public static final String PARAMETER_MAX_RUNS = "max_runs";
    public static final String PARAMETER_MAX_OPTIMIZATION_STEPS = "max_optimization_steps";
    private DistanceMeasureHelper measureHelper = new DistanceMeasureHelper(this);

    public KMedoids(OperatorDescription description) {
        super(description);
        this.getExampleSetInputPort().addPrecondition(new DistanceMeasurePrecondition(this.getExampleSetInputPort(), this));
    }

    @Override
    public boolean supportsCapability(OperatorCapability capability) {
        int measureType = 0;
        try {
            measureType = this.measureHelper.getSelectedMeasureType();
        }
        catch (Exception exception) {
            // empty catch block
        }
        switch (capability) {
            case BINOMINAL_ATTRIBUTES: 
            case POLYNOMINAL_ATTRIBUTES: {
                return measureType == 0 || measureType == 1;
            }
            case NUMERICAL_ATTRIBUTES: {
                return measureType == 0 || measureType == 3 || measureType == 2;
            }
            case POLYNOMINAL_LABEL: 
            case BINOMINAL_LABEL: 
            case NUMERICAL_LABEL: 
            case WEIGHTED_EXAMPLES: 
            case MISSING_VALUES: {
                return true;
            }
        }
        return false;
    }

    @Override
    public ClusterModel generateClusterModel(ExampleSet exampleSet) throws OperatorException {
        int k = this.getParameterAsInt(PARAMETER_K);
        int maxOptimizationSteps = this.getParameterAsInt(PARAMETER_MAX_OPTIMIZATION_STEPS);
        int maxRuns = this.getParameterAsInt(PARAMETER_MAX_RUNS);
        DistanceMeasure measure = this.measureHelper.getInitializedMeasure(exampleSet);
        Tools.checkAndCreateIds(exampleSet);
        Tools.onlyNonMissingValues(exampleSet, "KMedoids");
        if (exampleSet.size() < k) {
            throw new UserError((Operator)this, 142, k);
        }
        Attributes attributes = exampleSet.getAttributes();
        ArrayList<String> attributeNames = new ArrayList<String>(attributes.size());
        for (Attribute attribute : attributes) {
            attributeNames.add(attribute.getName());
        }
        RandomGenerator generator = RandomGenerator.getRandomGenerator(this);
        double minimalIntraClusterDistance = Double.POSITIVE_INFINITY;
        ClusterModel bestModel = null;
        int[] bestAssignments = null;
        for (int iter = 0; iter < maxRuns; ++iter) {
            this.checkForStop();
            CentroidClusterModel model = new CentroidClusterModel(exampleSet, k, attributeNames, measure, this.getParameterAsBoolean("add_as_label"), this.getParameterAsBoolean("remove_unlabeled"));
            int i = 0;
            for (Integer index : generator.nextIntSetWithRange(0, exampleSet.size(), k)) {
                model.assignExample(i, this.getAsDoubleArray(exampleSet.getExample(index), attributes));
                ++i;
            }
            model.finishAssign();
            int[] centroidAssignments = new int[exampleSet.size()];
            boolean stable = false;
            for (int step = 0; step < maxOptimizationSteps && !stable; ++step) {
                this.checkForStop();
                i = 0;
                for (Example example : exampleSet) {
                    double[] exampleValues = this.getAsDoubleArray(example, attributes);
                    double nearestDistance = measure.calculateDistance(model.getCentroidCoordinates(0), exampleValues);
                    int nearestIndex = 0;
                    for (int centroidIndex = 1; centroidIndex < k; ++centroidIndex) {
                        double distance = measure.calculateDistance(model.getCentroidCoordinates(centroidIndex), exampleValues);
                        if (!(distance < nearestDistance)) continue;
                        nearestDistance = distance;
                        nearestIndex = centroidIndex;
                    }
                    centroidAssignments[i] = nearestIndex;
                    ++i;
                }
                for (int clusterIndex = 0; clusterIndex < k; ++clusterIndex) {
                    double[] bestMedoidValues = new double[attributes.size()];
                    double bestDistanceSum = Double.POSITIVE_INFINITY;
                    for (Example medoid : exampleSet) {
                        double distanceSum = 0.0;
                        double[] medoidValues = this.getAsDoubleArray(medoid, attributes);
                        int j = 0;
                        for (Example example : exampleSet) {
                            if (centroidAssignments[j] == clusterIndex) {
                                distanceSum += measure.calculateDistance(this.getAsDoubleArray(example, attributes), medoidValues);
                            }
                            ++j;
                        }
                        if (!(distanceSum < bestDistanceSum)) continue;
                        bestDistanceSum = distanceSum;
                        bestMedoidValues = medoidValues;
                    }
                    model.getCentroid(clusterIndex).assignExample(bestMedoidValues);
                }
                stable = model.finishAssign();
            }
            double distanceSum = 0.0;
            i = 0;
            for (Example example : exampleSet) {
                double distance = measure.calculateDistance(model.getCentroidCoordinates(centroidAssignments[i]), this.getAsDoubleArray(example, attributes));
                distanceSum += distance * distance;
                ++i;
            }
            if (!(distanceSum < minimalIntraClusterDistance) && !Double.isInfinite(minimalIntraClusterDistance)) continue;
            bestModel = model;
            minimalIntraClusterDistance = distanceSum;
            bestAssignments = centroidAssignments;
        }
        bestModel.setClusterAssignments(bestAssignments, exampleSet);
        if (this.addsClusterAttribute()) {
            Attribute cluster = AttributeFactory.createAttribute("cluster", 1);
            exampleSet.getExampleTable().addAttribute(cluster);
            exampleSet.getAttributes().setCluster(cluster);
            int i = 0;
            for (Example example : exampleSet) {
                example.setValue(cluster, "cluster_" + (int)bestAssignments[i]);
                ++i;
            }
        }
        return bestModel;
    }

    private double[] getAsDoubleArray(Example example, Attributes attributes) {
        double[] values = new double[attributes.size()];
        int i = 0;
        for (Attribute attribute : attributes) {
            values[i] = example.getValue(attribute);
            ++i;
        }
        return values;
    }

    @Override
    public Class<? extends ClusterModel> getClusterModelClass() {
        return CentroidClusterModel.class;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeInt(PARAMETER_K, "The number of clusters which should be detected.", 2, Integer.MAX_VALUE, 2, false));
        types.add(new ParameterTypeInt(PARAMETER_MAX_RUNS, "The maximal number of runs of k-Means with random initialization that are performed.", 1, Integer.MAX_VALUE, 10, false));
        types.add(new ParameterTypeInt(PARAMETER_MAX_OPTIMIZATION_STEPS, "The maximal number of iterations performed for one run of k-Means.", 1, Integer.MAX_VALUE, 100, false));
        types.addAll(RandomGenerator.getRandomGeneratorParameters(this));
        types.addAll(DistanceMeasures.getParameterTypes(this));
        return types;
    }
}

