/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.clustering.clusterer;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCapability;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.clustering.CentroidClusterModel;
import com.rapidminer.operator.clustering.ClusterModel;
import com.rapidminer.operator.clustering.clusterer.DistanceMatrix;
import com.rapidminer.operator.clustering.clusterer.RMAbstractClusterer;
import com.rapidminer.operator.learner.CapabilityProvider;
import com.rapidminer.operator.ports.metadata.CapabilityPrecondition;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.tools.RandomGenerator;
import com.rapidminer.tools.math.similarity.DistanceMeasure;
import com.rapidminer.tools.math.similarity.numerical.EuclideanDistance;
import java.util.ArrayList;
import java.util.List;

public class FastKMeans
extends RMAbstractClusterer
implements CapabilityProvider {
    public static final String PARAMETER_K = "k";
    public static final String PARAMETER_MAX_RUNS = "max_runs";
    public static final String PARAMETER_MAX_OPTIMIZATION_STEPS = "max_optimization_steps";

    public FastKMeans(OperatorDescription description) {
        super(description);
        this.getExampleSetInputPort().addPrecondition(new CapabilityPrecondition(this, this.getExampleSetInputPort()));
    }

    @Override
    public ClusterModel generateClusterModel(ExampleSet exampleSet) throws OperatorException {
        int k = this.getParameterAsInt(PARAMETER_K);
        int maxOptimizationSteps = this.getParameterAsInt(PARAMETER_MAX_OPTIMIZATION_STEPS);
        int maxRuns = this.getParameterAsInt(PARAMETER_MAX_RUNS);
        EuclideanDistance measure = new EuclideanDistance();
        ((DistanceMeasure)measure).init(exampleSet);
        Tools.checkAndCreateIds(exampleSet);
        Tools.onlyNonMissingValues(exampleSet, "KMeans");
        if (exampleSet.size() < k) {
            throw new UserError((Operator)this, 142, k);
        }
        Attributes attributes = exampleSet.getAttributes();
        ArrayList<String> attributeNames = new ArrayList<String>(attributes.size());
        for (Attribute attribute : attributes) {
            attributeNames.add(attribute.getName());
        }
        RandomGenerator generator = RandomGenerator.getRandomGenerator(this);
        double minimalIntraClusterDistance = Double.POSITIVE_INFINITY;
        ClusterModel bestModel = null;
        int[] bestAssignments = null;
        for (int iter = 0; iter < maxRuns; ++iter) {
            this.checkForStop();
            CentroidClusterModel model = new CentroidClusterModel(exampleSet, k, attributeNames, measure, this.getParameterAsBoolean("add_as_label"), this.getParameterAsBoolean("remove_unlabeled"));
            int i = 0;
            for (Integer index : generator.nextIntSetWithRange(0, exampleSet.size(), k)) {
                model.assignExample(i, this.getAsDoubleArray(exampleSet.getExample(index), attributes));
                ++i;
            }
            model.finishAssign();
            double[][] l = new double[exampleSet.size()][k];
            double[] u = new double[exampleSet.size()];
            boolean[] r = new boolean[exampleSet.size()];
            double[][] m_old = new double[k][attributes.size()];
            double[] s = new double[k];
            int[] centroidAssignments = new int[exampleSet.size()];
            DistanceMatrix centroidDistances = new DistanceMatrix(k);
            this.computeClusterDistances(centroidDistances, s, model, measure);
            int x = 0;
            for (Example example : exampleSet) {
                double nearestDistance;
                double[] exampleValues = this.getAsDoubleArray(example, attributes);
                l[x][0] = nearestDistance = ((DistanceMeasure)measure).calculateDistance(model.getCentroidCoordinates(0), exampleValues);
                int nearestIndex = 0;
                for (int centroidIndex = 1; centroidIndex < k; ++centroidIndex) {
                    double distance;
                    if (centroidDistances.get(nearestIndex, centroidIndex) >= 2.0 * nearestDistance) continue;
                    l[x][centroidIndex] = distance = ((DistanceMeasure)measure).calculateDistance(model.getCentroidCoordinates(centroidIndex), exampleValues);
                    if (!(distance < nearestDistance)) continue;
                    nearestDistance = distance;
                    nearestIndex = centroidIndex;
                }
                centroidAssignments[x] = nearestIndex;
                u[x] = nearestDistance;
                r[x] = false;
                ++x;
            }
            boolean stable = false;
            for (int step = 0; step < maxOptimizationSteps && !stable; ++step) {
                int c;
                this.computeClusterDistances(centroidDistances, s, model, measure);
                int avoidedSamples = 0;
                x = 0;
                for (Example example : exampleSet) {
                    double[] exampleValue = this.getAsDoubleArray(example, attributes);
                    if (u[x] <= s[centroidAssignments[x]]) {
                        ++avoidedSamples;
                    } else {
                        for (int c2 = 0; c2 < k; ++c2) {
                            double d_x_c_new;
                            double d_x_c;
                            if (c2 == centroidAssignments[x] || !(u[x] > l[x][c2]) || !(u[x] > 0.5 * centroidDistances.get(centroidAssignments[x], c2))) continue;
                            if (r[x]) {
                                l[x][centroidAssignments[x]] = d_x_c = ((DistanceMeasure)measure).calculateDistance(exampleValue, model.getCentroidCoordinates(centroidAssignments[x]));
                                u[x] = d_x_c;
                                r[x] = false;
                            } else {
                                d_x_c = u[x];
                            }
                            if (!(d_x_c > l[x][c2]) || !(d_x_c > 0.5 * centroidDistances.get(centroidAssignments[x], c2))) continue;
                            l[x][c2] = d_x_c_new = ((DistanceMeasure)measure).calculateDistance(exampleValue, model.getCentroidCoordinates(c2));
                            if (!(d_x_c_new < d_x_c)) continue;
                            centroidAssignments[x] = c2;
                            u[x] = d_x_c_new;
                        }
                    }
                    model.assignExample(centroidAssignments[x], exampleValue);
                    ++x;
                }
                for (int c3 = 0; c3 < k; ++c3) {
                    m_old[c3] = model.getCentroidCoordinates(c3);
                }
                stable = model.finishAssign();
                double[] mean_distances = new double[k];
                for (c = 0; c < k; ++c) {
                    mean_distances[c] = ((DistanceMeasure)measure).calculateDistance(m_old[c], model.getCentroidCoordinates(c));
                }
                for (x = 0; x < exampleSet.size(); ++x) {
                    for (c = 0; c < k; ++c) {
                        double d = l[x][c] - mean_distances[c];
                        l[x][c] = d > 0.0 ? d : 0.0;
                    }
                    u[x] = u[x] + mean_distances[centroidAssignments[x]];
                    r[x] = true;
                }
            }
            double distanceSum = 0.0;
            i = 0;
            for (Example example : exampleSet) {
                double distance = ((DistanceMeasure)measure).calculateDistance(model.getCentroidCoordinates(centroidAssignments[i]), this.getAsDoubleArray(example, attributes));
                distanceSum += distance * distance;
                ++i;
            }
            if (!(distanceSum < minimalIntraClusterDistance)) continue;
            bestModel = model;
            minimalIntraClusterDistance = distanceSum;
            bestAssignments = centroidAssignments;
        }
        bestModel.setClusterAssignments(bestAssignments, exampleSet);
        if (this.addsClusterAttribute()) {
            Attribute cluster = AttributeFactory.createAttribute("cluster", 1);
            exampleSet.getExampleTable().addAttribute(cluster);
            exampleSet.getAttributes().setCluster(cluster);
            int i = 0;
            for (Example example : exampleSet) {
                example.setValue(cluster, "cluster_" + (int)bestAssignments[i]);
                ++i;
            }
        }
        return bestModel;
    }

    private void computeClusterDistances(DistanceMatrix centroidDistances, double[] s, CentroidClusterModel model, DistanceMeasure measure) {
        int i;
        for (i = 0; i < model.getNumberOfClusters(); ++i) {
            s[i] = Double.POSITIVE_INFINITY;
        }
        for (i = 0; i < model.getNumberOfClusters(); ++i) {
            for (int j = i + 1; j < model.getNumberOfClusters(); ++j) {
                double d = measure.calculateDistance(model.getCentroidCoordinates(i), model.getCentroidCoordinates(j));
                if (d < s[i]) {
                    s[i] = d;
                }
                if (d < s[j]) {
                    s[j] = d;
                }
                centroidDistances.set(i, j, d);
            }
        }
        for (i = 0; i < model.getNumberOfClusters(); ++i) {
            s[i] = 0.5 * s[i];
        }
    }

    private double[] getAsDoubleArray(Example example, Attributes attributes) {
        double[] values = new double[attributes.size()];
        int i = 0;
        for (Attribute attribute : attributes) {
            values[i] = example.getValue(attribute);
            ++i;
        }
        return values;
    }

    @Override
    public Class<? extends ClusterModel> getClusterModelClass() {
        return CentroidClusterModel.class;
    }

    @Override
    public boolean supportsCapability(OperatorCapability capability) {
        switch (capability) {
            case BINOMINAL_ATTRIBUTES: 
            case POLYNOMINAL_ATTRIBUTES: {
                return false;
            }
        }
        return true;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeInt(PARAMETER_K, "The number of clusters which should be detected.", 2, Integer.MAX_VALUE, 2, false));
        types.add(new ParameterTypeInt(PARAMETER_MAX_RUNS, "The maximal number of runs of k-Means with random initialization that are performed.", 1, Integer.MAX_VALUE, 10, false));
        types.add(new ParameterTypeInt(PARAMETER_MAX_OPTIMIZATION_STEPS, "The maximal number of iterations performed for one run of k-Means.", 1, Integer.MAX_VALUE, 100, false));
        types.addAll(RandomGenerator.getRandomGeneratorParameters(this));
        return types;
    }
}

