/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.clustering.clusterer;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.clustering.ClusterModel;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.AttributeSetPrecondition;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetPassThroughRule;
import com.rapidminer.operator.ports.metadata.ExampleSetPrecondition;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttribute;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.tools.metadata.MetaDataTools;
import java.util.HashMap;
import java.util.List;

public class ExampleSet2ClusterModel
extends Operator {
    public static final String PARAMETER_ATTRIBUTE = "attribute";
    public static final String PARAMETER_REMOVE_UNLABELED = "remove_unlabeled";
    public static final String PARAMETER_ADD_AS_LABEL = "add_as_label";
    private InputPort exampleSetInput = (InputPort)this.getInputPorts().createPort("example set");
    private OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set");
    private OutputPort modelOutput = (OutputPort)this.getOutputPorts().createPort("cluster model");

    public ExampleSet2ClusterModel(OperatorDescription description) {
        super(description);
        this.exampleSetInput.addPrecondition(new ExampleSetPrecondition(this.exampleSetInput));
        this.exampleSetInput.addPrecondition(new AttributeSetPrecondition(this.exampleSetInput, AttributeSetPrecondition.getAttributesByParameter(this, PARAMETER_ATTRIBUTE), new String[0]));
        this.getTransformer().addRule(new ExampleSetPassThroughRule(this.exampleSetInput, this.exampleSetOutput, SetRelation.EQUAL){

            @Override
            public ExampleSetMetaData modifyExampleSet(ExampleSetMetaData metaData) {
                MetaDataTools.checkAndCreateIds(metaData);
                return metaData;
            }
        });
        this.getTransformer().addGenerationRule(this.modelOutput, ClusterModel.class);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void doWork() throws OperatorException {
        ExampleSet exampleSet = (ExampleSet)this.exampleSetInput.getData();
        Tools.checkAndCreateIds(exampleSet);
        Attribute attribute = exampleSet.getAttributes().get(this.getParameterAsString(PARAMETER_ATTRIBUTE));
        if (attribute == null) throw new UserError((Operator)this, 111, this.getParameterAsString(PARAMETER_ATTRIBUTE));
        if (!attribute.isNominal()) throw new UserError((Operator)this, 119, this.getParameterAsString(PARAMETER_ATTRIBUTE), "ExampleSet2ClusterModel");
        HashMap<Double, Integer> valueMap = new HashMap<Double, Integer>();
        int[] clusterAssignments = new int[exampleSet.size()];
        int i = 0;
        for (Example example : exampleSet) {
            double value = example.getValue(attribute);
            if (valueMap.containsKey(value)) {
                clusterAssignments[i] = (Integer)valueMap.get(value);
            } else {
                clusterAssignments[i] = valueMap.size();
                valueMap.put(value, valueMap.size());
            }
            ++i;
        }
        ClusterModel model = new ClusterModel(exampleSet, valueMap.size(), this.getParameterAsBoolean(PARAMETER_ADD_AS_LABEL), this.getParameterAsBoolean(PARAMETER_REMOVE_UNLABELED));
        model.setClusterAssignments(clusterAssignments, exampleSet);
        this.modelOutput.deliver(model);
        this.exampleSetOutput.deliver(exampleSet);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeAttribute(PARAMETER_ATTRIBUTE, "Specifies the nominal attribute used to create the cluster", this.exampleSetInput, false));
        ParameterTypeBoolean type = new ParameterTypeBoolean(PARAMETER_ADD_AS_LABEL, "Should the cluster values be added as label.", false);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeBoolean(PARAMETER_REMOVE_UNLABELED, "Delete the unlabeled examples.", false);
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

